Attribute VB_Name = "Values_Mix_Mdl"
'THIS MODULE PROVIDES AN EASY WAY FOR THE USER TO COMPARE RESULTS FROM THE MULTI-PHASE ROUTINES
'RUN LOCALLY WITH THE CHECK VALUES PROVIDED IN THE VARIOUS ROUTINES


'THIS MODULE REQUIRES
'     CONSTANTS_0_mdl,   FILE CONSTANTS_0.bas
'     CONVERT_0_mdl,     FILE CONVERT_0.bas
'     MATHS_0_mdl,       FILE MATHS_0.bas
'     AIR_1_mdl,         FILE AIR_1.bas
'     AIR_2_mdl,         FILE AIR_2.bas
'     FLU_1_mdl,         FILE FLU_1.bas
'     FLU_2_mdl,         FILE FLU_2.bas
'     FLU_3A_mdl,        FILE FLU_3A.bas
'     FLU_3B_mdl,        FILE FLU_3B.bas
'     ICE_1_mdl,         FILE ICE_1.bas
'     ICE_2_mdl,         FILE ICE_2.bas
'     SAL_1_mdl,         FILE ICE_1.bas
'     SAL_2_mdl,         FILE ICE_2.bas
'     SEA_3A_mdl,        FILE SEA_3A.bas
'     SEA_3B_mdl,        FILE SEA_3B.bas
'     SEA_3C_mdl,        FILE SEA_3C.bas
'     SEA_3D_mdl,        FILE SEA_3D.bas
'     ICE_AIR_4A_mdl,    FILE ICE_AIR_4A.bas
'     ICE_AIR_4B_mdl,    FILE ICE_AIR_4B.bas
'     ICE_AIR_4C_mdl,    FILE ICE_AIR_4C.bas
'     ICE_LIQ_4_mdl,     FILE ICE_LIQ_4.bas
'     ICE_VAP_4_mdl,     FILE ICE_VAP_4.bas
'     LIQ_AIR_4A_mdl,    FILE LIQ_AIR_4A.bas
'     LIQ_AIR_4B_mdl,    FILE LIQ_AIR_4B.bas
'     LIQ_AIR_4C_mdl,    FILE LIQ_AIR_4B.bas
'     LIQ_VAP_4_mdl,     FILE LIQ_VAP_4.bas
'     LIQ_ICE_AIR_4_mdl, FILE LIQ_ICE_AIR_4.bas
'     SEA_AIR_4_mdl,     FILE SEA_AIR_4.bas
'     SEA_ICE_4_mdl,     FILE SEA_ICE_4.bas
'     SEA_ICE_VAP_4_mdl, FILE SEA_ICE_VAP_4.bas
'     SEA_LIQ_4_mdl,     FILE SEA_LIQ_4.bas
'     SEA_VAP_4_mdl,     FILE SEA_VAP_4.bas


Option Explicit

Private Const Version = "07 Jun 2010"
'==========================================================================
Public Function mix_check_values() As String

Dim txt As String, CRLF As String, TB As String

CRLF = Chr(13) + Chr(10)
TB = Chr(9)

If Molar_mass_air_L2000 = Molar_mass_air_si Then

  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  'RESULTS CORRESPONDING TO VERSION 1.1 (V. 1.1)
  'NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  'MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  'THE PORTION OF THE CODE BELOW (FROM HERE TO ELSEIF) USES THIS VALUE OF THE MOLAR MASS.
  'TO USES THE ORIGINAL VALUE USED BY LEMMON ET AL. (2000) YOU MUST EDIT CONSTANTS_0 TO
  'CORRESPOND TO VERSION 1.0 (v. 1.0).
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = "COMPARISON OF CHECK VALUES FOR PROPERTIES OF EQUILIBRIUM STATES, SIA VERSION 1.1" + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4A" + CRLF + CRLF
  
  txt = txt + "ice_air_massfraction_air_si(270,1E5)        =" + TwoCols(ice_air_massfraction_air_si(270#, 100000#), 0.99705885472045) + CRLF
  txt = txt + "ice_air_frostpoint_si(0.997,1E5)            =" + TwoCols(ice_air_frostpoint_si(0.997, 100000#), 270.234816125585) + CRLF
  txt = txt + "ice_air_ict_si(0.997,300,1E5)               =" + TwoCols(ice_air_ict_si(0.997, 300#, 100000#), 265.224998410772) + CRLF
  txt = txt + "ice_air_icl_si(0.997,300,1E5)               =" + TwoCols(ice_air_icl_si(0.997, 300#, 100000#), 64988.3931837714) + CRLF
  txt = txt + "ice_air_condensationpressure_si(0.997,270)  =" + TwoCols(ice_air_condensationpressure_si(0.997, 270#), 98034.4511232545) + CRLF
  txt = txt + "ice_air_sublimationpressure_si(270,1E5)     =" + TwoCols(ice_air_sublimationpressure_si(270, 100000#), 472.041823974569) + CRLF
  txt = txt + "ice_air_rh_cct_from_a_si(0.998,270,1E5)     =" + TwoCols(ice_air_rh_cct_from_a_si(0.998, 270#, 100000#), 0.680395740552732) + CRLF
  txt = txt + "ice_air_rh_wmo_from_a_si(0.998,270,1E5)     =" + TwoCols(ice_air_rh_wmo_from_a_si(0.998, 270#, 100000#), 0.679365943331199) + CRLF
  txt = txt + "ice_air_a_from_rh_wmo_si(0.8,270,1E5)       =" + TwoCols(ice_air_a_from_rh_wmo_si(0.8, 270#, 100000#), 0.997645698908051) + CRLF
  txt = txt + "ice_air_a_from_rh_cct_si(0.8,270,1E5)       =" + TwoCols(ice_air_a_from_rh_cct_si(0.8, 270#, 100000#), 0.997647924742855) + CRLF
  txt = txt + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833359.27614458) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833386.54979848) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833296.51317304) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2834612.4235116) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.28880078014467) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.26340801028285) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.28763121401902) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 0.949325026119047) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.79055033080274E-03) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.79022403084856E-03) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.86289364205706E-03) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 2.84797507835715E-03) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 100000) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 98034.4511232545) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 100000) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 72721.4579414585) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270.234816125585) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 266.514349349924) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.181167191815) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.180955860772) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.14706052663) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.681749113666) + CRLF
  txt = txt + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4B" + CRLF + CRLF
  
  txt = txt + "ice_air_g_si(0, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 0, 0.5, 270, 100000), -2595.57166633752) + CRLF
  txt = txt + "ice_air_g_si(1, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 0, 0, 0.5, 270, 100000), 2382.35592988117) + CRLF
  txt = txt + "ice_air_g_si(0, 1, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 1, 0, 0.5, 270, 100000), 610.264515317715) + CRLF
  txt = txt + "ice_air_g_si(0, 0, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 1, 0.5, 270, 100000), 0.389645501223942) + CRLF
  txt = txt + "ice_air_g_si(2, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(2, 0, 0, 0.5, 270, 100000), 0) + CRLF
  txt = txt + "ice_air_g_si(1, 1, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 1, 0, 0.5, 270, 100000), -1269.4176794934) + CRLF
  txt = txt + "ice_air_g_si(1, 0, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 0, 1, 0.5, 270, 100000), 0.777110408175409) + CRLF
  txt = txt + "ice_air_g_si(0, 2, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 2, 0, 0.5, 270, 100000), -7.00810930740276) + CRLF
  txt = txt + "ice_air_g_si(0, 1, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 1, 1, 0.5, 270, 100000), 1.60095965101151E-03) + CRLF
  txt = txt + "ice_air_g_si(0, 0, 2, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 2, 0.5, 270, 100000), -3.91178603884919E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "ice_air_solidfraction_si(0.5, 270, 1E5)  =" + TwoCols(ice_air_solidfraction_si(0.5, 270, 100000), 0.498525089433976) + CRLF
  txt = txt + "ice_air_vapourfraction_si(0.5, 270, 1E5) =" + TwoCols(ice_air_vapourfraction_si(0.5, 270, 100000), 1.47491056602398E-03) + CRLF
  txt = txt + "ice_air_g_cp_si(0.5, 270, 1E5)           =" + TwoCols(ice_air_g_cp_si(0.5, 270, 100000), 1892.18951299875) + CRLF
  txt = txt + "ice_air_g_density_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_density_si(0.5, 270, 100000), 2.56643538000268) + CRLF
  txt = txt + "ice_air_g_enthalpy_si(0.5, 270, 1E5)     =" + TwoCols(ice_air_g_enthalpy_si(0.5, 270, 100000), -167366.99080212) + CRLF
  txt = txt + "ice_air_g_entropy_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_entropy_si(0.5, 270, 100000), -610.264515317715) + CRLF
  txt = txt + "ice_air_g_expansion_si(0.5, 270, 1E5)    =" + TwoCols(ice_air_g_expansion_si(0.5, 270, 100000), 4.10875949031269E-03) + CRLF
  txt = txt + "ice_air_g_kappa_t_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_kappa_t_si(0.5, 270, 100000), 1.00393460891031E-05) + CRLF
  txt = txt + "ice_air_g_lapserate_si(0.5, 270, 1E5)    =" + TwoCols(ice_air_g_lapserate_si(0.5, 270, 100000), 2.28443875628538E-04) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4C" + CRLF + CRLF
  
  txt = txt + "ice_air_h_si(0, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 0, 0.5, -600, 100000), -164588.106002375) + CRLF
  txt = txt + "ice_air_h_si(1, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 0, 0, 0.5, -600, 100000), 543.016638396322) + CRLF
  txt = txt + "ice_air_h_si(0, 1, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 1, 0, 0.5, -600, 100000), 271.449994437192) + CRLF
  txt = txt + "ice_air_h_si(0, 0, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 1, 0.5, -600, 100000), 0.391981878510342) + CRLF
  txt = txt + "ice_air_h_si(2, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(2, 0, 0, 0.5, -600, 100000), 224958.5258639) + CRLF
  txt = txt + "ice_air_h_si(1, 1, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 1, 0, 0.5, -600, 100000), -177.457078495317) + CRLF
  txt = txt + "ice_air_h_si(1, 0, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 0, 1, 0.5, -600, 100000), 0.781782661019485) + CRLF
  txt = txt + "ice_air_h_si(0, 2, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 2, 0, 0.5, -600, 100000), 0.139985868893652) + CRLF
  txt = txt + "ice_air_h_si(0, 1, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 1, 1, 0.5, -600, 100000), 2.26912930198746E-04) + CRLF
  txt = txt + "ice_air_h_si(0, 0, 2, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 2, 0.5, -600, 100000), -3.56976697603203E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "ice_air_pottemp_si(0.9, 230, 5d4, 1E5)     =" + TwoCols(ice_air_pottemp_si(0.9, 230, 50000, 100000), 266.105208870657) + CRLF
  txt = txt + "ice_air_potdensity_si(0.9, 230, 5d4, 1E5)  =" + TwoCols(ice_air_potdensity_si(0.9, 230, 50000, 100000), 1.45048110421887) + CRLF
  txt = txt + "ice_air_potenthalpy_si(0.9, 230, 5d4, 1E5) =" + TwoCols(ice_air_potenthalpy_si(0.9, 230, 50000, 100000), -35781.2564451371) + CRLF
  txt = txt + "ice_air_h_temperature_si(0.9, -100, 1E5)   =" + TwoCols(ice_air_h_temperature_si(0.9, -100, 100000), 270.383680119296) + CRLF
  txt = txt + "ice_air_h_lapserate_si(0.9, -100, 1E5)     =" + TwoCols(ice_air_h_lapserate_si(0.9, -100, 100000), 4.42457786754781E-04) + CRLF
  txt = txt + "ice_air_h_cp_si(0.9, -100, 1E5)            =" + TwoCols(ice_air_h_cp_si(0.9, -100, 100000), 1766.52051487688) + CRLF
  txt = txt + "ice_air_h_kappa_s_si(0.9, -100, 1E5)       =" + TwoCols(ice_air_h_kappa_s_si(0.9, -100, 100000), 8.23031581046871E-06) + CRLF
  txt = txt + "ice_air_h_density_si(0.9, -100, 1E5)       =" + TwoCols(ice_air_h_density_si(0.9, -100, 100000), 1.4253189599345) + CRLF
  txt = txt + CRLF + CRLF

Else

'SIA Version 1.0:
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  '!RESULTS CORRESPONDING TO VERSION 1.0 (V1.0)
  '!NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  '!MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  '!THE PORTION OF THE CODE BELOW (FROM HERE TO ENDIF) WILL ONLY BE ACTIVATED IF
  '!YOU CHANGE TO VERSION 1.0 (V1.0) IN CONSTANTS_0
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = "COMPARISON OF CHECK VALUES FOR PROPERTIES OF EQUILIBRIUM STATES, SIA VERSION 1.0" + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4A" + CRLF + CRLF
  
  txt = txt + "ice_air_massfraction_air_si(270,1E5)        =" + TwoCols(ice_air_massfraction_air_si(270#, 100000#), 0.997058162463562) + CRLF
  txt = txt + "ice_air_frostpoint_si(0.997,1E5)            =" + TwoCols(ice_air_frostpoint_si(0.997, 100000#), 270.232024745999) + CRLF
  txt = txt + "ice_air_ict_si(0.997,300,1E5)               =" + TwoCols(ice_air_ict_si(0.997, 300#, 100000#), 265.221832079309) + CRLF
  txt = txt + "ice_air_icl_si(0.997,300,1E5)               =" + TwoCols(ice_air_icl_si(0.997, 300#, 100000#), 64985.6857989397) + CRLF
  txt = txt + "ice_air_condensationpressure_si(0.997,270)  =" + TwoCols(ice_air_condensationpressure_si(0.997, 270#), 98057.5687059715) + CRLF
  txt = txt + "ice_air_sublimationpressure_si(270,1E5)     =" + TwoCols(ice_air_sublimationpressure_si(270, 100000#), 472.041436186353) + CRLF
  txt = txt + "ice_air_rh_cct_from_a_si(0.998,270,1E5)     =" + TwoCols(ice_air_rh_cct_from_a_si(0.998, 270#, 100000#), 0.680235676087008) + CRLF
  txt = txt + "ice_air_rh_wmo_from_a_si(0.998,270,1E5)     =" + TwoCols(ice_air_rh_wmo_from_a_si(0.998, 270#, 100000#), 0.679205607134528) + CRLF
  txt = txt + "ice_air_a_from_rh_wmo_si(0.8,270,1E5)       =" + TwoCols(ice_air_a_from_rh_wmo_si(0.8, 270#, 100000#), 0.99764514445036) + CRLF
  txt = txt + "ice_air_a_from_rh_cct_si(0.8,270,1E5)       =" + TwoCols(ice_air_a_from_rh_cct_si(0.8, 270#, 100000#), 0.997647370806294) + CRLF
  txt = txt + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833359.68774939) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833386.63215386) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2833297.67344217) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_enthalpy_subl_si =" + TwoCols(ice_air_enthalpy_subl_si, 2834613.25617893) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.28849644314825) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.26340826697391) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 1.28734106365448) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_air_si   =" + TwoCols(ice_air_density_air_si, 0.949136077891348) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.79054720201974E-03) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.79022480092173E-03) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 3.86202319096345E-03) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_vap_si   =" + TwoCols(ice_air_density_vap_si, 2.84740823367405E-03) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 100000) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 98057.5687059715) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 100000) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_pressure_si      =" + TwoCols(ice_air_pressure_si, 72723.467704989) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 270.232024745999) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_temperature_si   =" + TwoCols(ice_air_temperature_si, 266.511951178006) + CRLF
  set_ice_air_eq_at_t_p 270, 100000
  txt = txt + "set_ice_air_eq_at_t_p 270, 1E5 :    ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.181167191815) + CRLF
  set_ice_air_eq_at_a_t 0.997, 270
  txt = txt + "set_ice_air_eq_at_a_t 0.997, 270:   ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.180958346319) + CRLF
  set_ice_air_eq_at_a_p 0.997, 100000
  txt = txt + "set_ice_air_eq_at_a_p .997, 1E5:    ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.14746610804) + CRLF
  set_ice_air_eq_at_a_eta 0.997, 100
  txt = txt + "set_ice_air_eq_at_a_eta 0.997, 100: ice_air_density_ice_si   =" + TwoCols(ice_air_density_ice_si, 917.682093943981) + CRLF
  txt = txt + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4B" + CRLF + CRLF
  
  txt = txt + "ice_air_g_si(0, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 0, 0.5, 270, 100000), -2595.73785824947) + CRLF
  txt = txt + "ice_air_g_si(1, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 0, 0, 0.5, 270, 100000), 2382.02354605727) + CRLF
  txt = txt + "ice_air_g_si(0, 1, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 1, 0, 0.5, 270, 100000), 610.261631356964) + CRLF
  txt = txt + "ice_air_g_si(0, 0, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 1, 0.5, 270, 100000), 0.389737675173871) + CRLF
  txt = txt + "ice_air_g_si(2, 0, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(2, 0, 0, 0.5, 270, 100000), 0) + CRLF
  txt = txt + "ice_air_g_si(1, 1, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 1, 0, 0.5, 270, 100000), -1269.4234474149) + CRLF
  txt = txt + "ice_air_g_si(1, 0, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(1, 0, 1, 0.5, 270, 100000), 0.777294756075268) + CRLF
  txt = txt + "ice_air_g_si(0, 2, 0, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 2, 0, 0.5, 270, 100000), -7.00885819160146) + CRLF
  txt = txt + "ice_air_g_si(0, 1, 1, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 1, 1, 0.5, 270, 100000), 1.60133877466081E-03) + CRLF
  txt = txt + "ice_air_g_si(0, 0, 2, 0.5, 270, 1E5) =" + TwoCols(ice_air_g_si(0, 0, 2, 0.5, 270, 100000), -3.91271268873414E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "ice_air_solidfraction_si(0.5, 270, 1E5)  =" + TwoCols(ice_air_solidfraction_si(0.5, 270, 100000), 0.498524741260245) + CRLF
  txt = txt + "ice_air_vapourfraction_si(0.5, 270, 1E5) =" + TwoCols(ice_air_vapourfraction_si(0.5, 270, 100000), 1.47525873975532E-03) + CRLF
  txt = txt + "ice_air_g_cp_si(0.5, 270, 1E5)           =" + TwoCols(ice_air_g_cp_si(0.5, 270, 100000), 1892.39171173239) + CRLF
  txt = txt + "ice_air_g_density_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_density_si(0.5, 270, 100000), 2.56582841151776) + CRLF
  txt = txt + "ice_air_g_enthalpy_si(0.5, 270, 1E5)     =" + TwoCols(ice_air_g_enthalpy_si(0.5, 270, 100000), -167366.37832463) + CRLF
  txt = txt + "ice_air_g_entropy_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_entropy_si(0.5, 270, 100000), -610.261631356964) + CRLF
  txt = txt + "ice_air_g_expansion_si(0.5, 270, 1E5)    =" + TwoCols(ice_air_g_expansion_si(0.5, 270, 100000), 4.10876052448974E-03) + CRLF
  txt = txt + "ice_air_g_kappa_t_si(0.5, 270, 1E5)      =" + TwoCols(ice_air_g_kappa_t_si(0.5, 270, 100000), 1.00393493828601E-05) + CRLF
  txt = txt + "ice_air_g_lapserate_si(0.5, 270, 1E5)    =" + TwoCols(ice_air_g_lapserate_si(0.5, 270, 100000), 2.28473558871494E-04) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_AIR_4C" + CRLF + CRLF
  
  txt = txt + "ice_air_h_si(0, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 0, 0.5, -600, 100000), -164588.277175128) + CRLF
  txt = txt + "ice_air_h_si(1, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 0, 0, 0.5, -600, 100000), 543.382787268341) + CRLF
  txt = txt + "ice_air_h_si(0, 1, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 1, 0, 0.5, -600, 100000), 271.449435547846) + CRLF
  txt = txt + "ice_air_h_si(0, 0, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 1, 0.5, -600, 100000), 0.392073699416254) + CRLF
  txt = txt + "ice_air_h_si(2, 0, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(2, 0, 0, 0.5, -600, 100000), 224938.714580441) + CRLF
  txt = txt + "ice_air_h_si(1, 1, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 1, 0, 0.5, -600, 100000), -177.440249222505) + CRLF
  txt = txt + "ice_air_h_si(1, 0, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(1, 0, 1, 0.5, -600, 100000), 0.78196630302515) + CRLF
  txt = txt + "ice_air_h_si(0, 2, 0, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 2, 0, 0.5, -600, 100000), 0.139971645622991) + CRLF
  txt = txt + "ice_air_h_si(0, 1, 1, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 1, 1, 0.5, -600, 100000), 2.26942461987265E-04) + CRLF
  txt = txt + "ice_air_h_si(0, 0, 2, 0.5, -600, 1E5) =" + TwoCols(ice_air_h_si(0, 0, 2, 0.5, -600, 100000), -3.57055653968235E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "ice_air_pottemp_si(0.9, 230, 5d4, 1E5)     =" + TwoCols(ice_air_pottemp_si(0.9, 230, 50000, 100000), 266.106323310295) + CRLF
  txt = txt + "ice_air_potdensity_si(0.9, 230, 5d4, 1E5)  =" + TwoCols(ice_air_potdensity_si(0.9, 230, 50000, 100000), 1.45013106602678) + CRLF
  txt = txt + "ice_air_potenthalpy_si(0.9, 230, 5d4, 1E5) =" + TwoCols(ice_air_potenthalpy_si(0.9, 230, 50000, 100000), -35779.7348518847) + CRLF
  txt = txt + "ice_air_h_temperature_si(0.9, -100, 1E5)   =" + TwoCols(ice_air_h_temperature_si(0.9, -100, 100000), 270.382806934047) + CRLF
  txt = txt + "ice_air_h_lapserate_si(0.9, -100, 1E5)     =" + TwoCols(ice_air_h_lapserate_si(0.9, -100, 100000), 4.42476802728586E-04) + CRLF
  txt = txt + "ice_air_h_cp_si(0.9, -100, 1E5)            =" + TwoCols(ice_air_h_cp_si(0.9, -100, 100000), 1766.84429536379) + CRLF
  txt = txt + "ice_air_h_kappa_s_si(0.9, -100, 1E5)       =" + TwoCols(ice_air_h_kappa_s_si(0.9, -100, 100000), 8.23024116522037E-06) + CRLF
  txt = txt + "ice_air_h_density_si(0.9, -100, 1E5)       =" + TwoCols(ice_air_h_density_si(0.9, -100, 100000), 1.42498657690712) + CRLF
  txt = txt + CRLF + CRLF

End If

txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_LIQ_4" + CRLF + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_chempot_si       =" + TwoCols(ice_liq_chempot_si, 9972.88171381369) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_chempot_si       =" + TwoCols(ice_liq_chempot_si, 38870.06051924) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_density_ice_si   =" + TwoCols(ice_liq_density_ice_si, 917.89669083078) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_density_ice_si   =" + TwoCols(ice_liq_density_ice_si, 921.35942851403) + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_density_liq_si   =" + TwoCols(ice_liq_density_liq_si, 1004.793536602) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_density_liq_si   =" + TwoCols(ice_liq_density_liq_si, 1019.05568894323) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_enthalpy_ice_si  =" + TwoCols(ice_liq_enthalpy_ice_si, -324602.983812453) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_enthalpy_ice_si  =" + TwoCols(ice_liq_enthalpy_ice_si, -299055.938629222) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_enthalpy_liq_si  =" + TwoCols(ice_liq_enthalpy_liq_si, 6945.92700482733) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_enthalpy_liq_si  =" + TwoCols(ice_liq_enthalpy_liq_si, 26110.7481093889) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_enthalpy_melt_si =" + TwoCols(ice_liq_enthalpy_melt_si, 331548.910817281) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_enthalpy_melt_si =" + TwoCols(ice_liq_enthalpy_melt_si, 325166.68673861) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_entropy_ice_si   =" + TwoCols(ice_liq_entropy_ice_si, -1228.2446413855) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_entropy_ice_si   =" + TwoCols(ice_liq_entropy_ice_si, -1251.57777462393) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_entropy_liq_si   =" + TwoCols(ice_liq_entropy_liq_si, -11.1121012723401) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_entropy_liq_si   =" + TwoCols(ice_liq_entropy_liq_si, -47.2567126290783) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_entropy_melt_si  =" + TwoCols(ice_liq_entropy_melt_si, 1217.13254011316) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_entropy_melt_si  =" + TwoCols(ice_liq_entropy_melt_si, 1204.32106199485) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_pressure_liq_si  =" + TwoCols(ice_liq_pressure_liq_si, 10000000.0069817) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_pressure_liq_si  =" + TwoCols(ice_liq_pressure_liq_si, 39313338.8824903) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_temperature_si   =" + TwoCols(ice_liq_temperature_si, 272.401648869143) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_temperature_si   =" + TwoCols(ice_liq_temperature_si, 270) + CRLF
txt = txt + CRLF

set_ice_liq_eq_at_p 10000000
txt = txt + "set_ice_liq_eq_at_p 1E7 : ice_liq_volume_melt_si   =" + TwoCols(ice_liq_volume_melt_si, -9.4217890328823E-05) + CRLF
set_ice_liq_eq_at_t 270
txt = txt + "set_ice_liq_eq_at_t 270 : ice_liq_volume_melt_si   =" + TwoCols(ice_liq_volume_melt_si, -1.04052121182316E-04) + CRLF
txt = txt + CRLF

txt = txt + "ice_liq_meltingpressure_si(270)                    =" + TwoCols(ice_liq_meltingpressure_si(270), 39313338.8824903) + CRLF
txt = txt + "ice_liq_meltingtemperature_si(1E7)                 =" + TwoCols(ice_liq_meltingtemperature_si(10000000), 272.401648869143) + CRLF
txt = txt + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_VAP_4" + CRLF + CRLF

txt = txt + "ice_vap_sublimationpressure_si(270)               =" + TwoCols(ice_vap_sublimationpressure_si(270), 470.059067980884) + CRLF
txt = txt + "ice_vap_sublimationtemp_si(100)                   =" + TwoCols(ice_vap_sublimationtemp_si(100), 252.817910214512) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_chempot_si       =" + TwoCols(ice_vap_chempot_si, -3895.2674739233) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_chempot_si       =" + TwoCols(ice_vap_chempot_si, -26421.2820403233) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_density_ice_si   =" + TwoCols(ice_vap_density_ice_si, 917.170465732797) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_density_ice_si   =" + TwoCols(ice_vap_density_ice_si, 919.600269744796) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_density_vap_si   =" + TwoCols(ice_vap_density_vap_si, 3.7740614077202E-03) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_density_vap_si   =" + TwoCols(ice_vap_density_vap_si, 8.57185487853061E-04) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_enthalpy_ice_si  =" + TwoCols(ice_vap_enthalpy_ice_si, -340033.434648698) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_enthalpy_ice_si  =" + TwoCols(ice_vap_enthalpy_ice_si, -374576.247867035) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_enthalpy_vap_si  =" + TwoCols(ice_vap_enthalpy_vap_si, 2495132.2197736) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_enthalpy_vap_si  =" + TwoCols(ice_vap_enthalpy_vap_si, 2463525.19629021) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_entropy_ice_si   =" + TwoCols(ice_vap_entropy_ice_si, -1244.95617472139) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_entropy_ice_si   =" + TwoCols(ice_vap_entropy_ice_si, -1377.09771246549) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_entropy_vap_si   =" + TwoCols(ice_vap_entropy_vap_si, 9255.65736017602) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_entropy_vap_si   =" + TwoCols(ice_vap_entropy_vap_si, 9848.7740691229) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_pressure_vap_si  =" + TwoCols(ice_vap_pressure_vap_si, 470.059067980884) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_pressure_vap_si  =" + TwoCols(ice_vap_pressure_vap_si, 100) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_temperature_si   =" + TwoCols(ice_vap_temperature_si, 270) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_temperature_si   =" + TwoCols(ice_vap_temperature_si, 252.817910214512) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_volume_subl_si   =" + TwoCols(ice_vap_volume_subl_si, 264.965451557852) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_volume_subl_si   =" + TwoCols(ice_vap_volume_subl_si, 1166.60755699012) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_entropy_subl_si  =" + TwoCols(ice_vap_entropy_subl_si, 10500.6135348974) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_entropy_subl_si  =" + TwoCols(ice_vap_entropy_subl_si, 11225.8717815884) + CRLF
txt = txt + CRLF

set_ice_vap_eq_at_t 270
txt = txt + "set_ice_vap_eq_at_t 270: ice_vap_enthalpy_subl_si =" + TwoCols(ice_vap_enthalpy_subl_si, 2835165.6544223) + CRLF
set_ice_vap_eq_at_p 100
txt = txt + "set_ice_vap_eq_at_p 100: ice_vap_enthalpy_subl_si =" + TwoCols(ice_vap_enthalpy_subl_si, 2838101.44415724) + CRLF
txt = txt + CRLF + CRLF

If Molar_mass_air_L2000 = Molar_mass_air_si Then

  'SIA Version 1.1:
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  'RESULTS CORRESPONDING TO VERSION 1.1 (V. 1.1)
  'NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  'MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  'THE PORTION OF THE CODE BELOW (FROM HERE TO ELSEIF) USES THIS VALUE OF THE MOLAR MASS.
  'TO USES THE ORIGINAL VALUE USED BY LEMMON ET AL. (2000) YOU MUST EDIT CONSTANTS_0 TO
  'CORRESPOND TO VERSION 1.0 (v. 1.0).
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_AIR_4A" + CRLF + CRLF
  
  txt = txt + "liq_air_massfraction_air_si(300, 1E5)      =" + TwoCols(liq_air_massfraction_air_si(300, 100000), 0.977605797727189) + CRLF
  txt = txt + "liq_air_dewpoint_si(0.99, 1E5)             =" + TwoCols(liq_air_dewpoint_si(0.99, 100000), 287.078299794842) + CRLF
  txt = txt + "liq_air_ict_si(0.99, 300, 1E5)             =" + TwoCols(liq_air_ict_si(0.99, 300, 100000), 284.200207629199) + CRLF
  txt = txt + "liq_air_icl_si(0.99, 300, 1E5)             =" + TwoCols(liq_air_icl_si(0.99, 300, 100000), 82723.6047630537) + CRLF
  txt = txt + "liq_air_condensationpressure_si(0.9, 300)  =" + TwoCols(liq_air_condensationpressure_si(0.9, 300), 23381.2332934951) + CRLF
  txt = txt + CRLF
  txt = txt + "liq_air_rh_cct_from_a_si(0.99, 300, 1E5)   =" + TwoCols(liq_air_rh_cct_from_a_si(0.99, 300, 100000), 0.449887886958951) + CRLF
  txt = txt + "liq_air_rh_wmo_from_a_si(0.99, 300, 1E5)   =" + TwoCols(liq_air_rh_wmo_from_a_si(0.99, 300, 100000), 0.440953686018889) + CRLF
  txt = txt + "liq_air_a_from_rh_wmo_si(0.8, 300, 1E5)    =" + TwoCols(liq_air_a_from_rh_wmo_si(0.8, 300, 100000), 0.982004037135254) + CRLF
  txt = txt + "liq_air_a_from_rh_cct_si(0.8, 300, 1E5)    =" + TwoCols(liq_air_a_from_rh_cct_si(0.8, 300, 100000), 0.982133277948147) + CRLF
  txt = txt + CRLF
  
  txt = txt + "liq_air_g_si(0, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 0, 0.5, 300, 100000), -5396.77820137313) + CRLF
  txt = txt + "liq_air_g_si(1, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 0, 0, 0.5, 300, 100000), -263.455491202659) + CRLF
  txt = txt + "liq_air_g_si(0, 1, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 1, 0, 0.5, 300, 100000), -343.78339387248) + CRLF
  txt = txt + "liq_air_g_si(0, 0, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 1, 0.5, 300, 100000), 0.446729465554996) + CRLF
  txt = txt + "liq_air_g_si(2, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(2, 0, 0, 0.5, 300, 100000), 0) + CRLF
  txt = txt + "liq_air_g_si(1, 1, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 1, 0, 0.5, 300, 100000), 98.5580798841792) + CRLF
  txt = txt + "liq_air_g_si(1, 0, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 0, 1, 0.5, 300, 100000), 0.89145201999123) + CRLF
  txt = txt + "liq_air_g_si(0, 2, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 2, 0, 0.5, 300, 100000), -14.0995955396963) + CRLF
  txt = txt + "liq_air_g_si(0, 1, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 1, 1, 0.5, 300, 100000), 2.43183979422311E-03) + CRLF
  txt = txt + "liq_air_g_si(0, 0, 2, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 2, 0.5, 300, 100000), -4.62360294022528E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "liq_air_liquidfraction_si(0.5, 300, 1E5) =" + TwoCols(liq_air_liquidfraction_si(0.5, 300, 100000), 0.488546404734467) + CRLF
  txt = txt + "liq_air_vapourfraction_si(0.5, 300, 1E5) =" + TwoCols(liq_air_vapourfraction_si(0.5, 300, 100000), 1.14535952655325E-02) + CRLF
  txt = txt + "liq_air_g_cp_si(0.5, 300, 1E5)           =" + TwoCols(liq_air_g_cp_si(0.5, 300, 100000), 4229.87866190888) + CRLF
  txt = txt + "liq_air_g_density_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_density_si(0.5, 300, 100000), 2.23849125053268) + CRLF
  txt = txt + "liq_air_g_entropy_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_entropy_si(0.5, 300, 100000), 343.78339387248) + CRLF
  txt = txt + "liq_air_g_expansion_si(0.5, 300, 1E5)    =" + TwoCols(liq_air_g_expansion_si(0.5, 300, 100000), 5.44365210206562E-03) + CRLF
  txt = txt + "liq_air_g_kappa_t_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_kappa_t_si(0.5, 300, 100000), 1.03498947276315E-05) + CRLF
  txt = txt + "liq_air_g_lapserate_si(0.5, 300, 1E5)    =" + TwoCols(liq_air_g_lapserate_si(0.5, 300, 100000), 1.72475854883671E-04) + CRLF
  txt = txt + CRLF
  
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2458121.74960753) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2465656.38629966) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2433111.29695544) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2434585.53919211) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 100) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 145.863545193528) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, -41.9991507402073) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 296.711483506936) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 290.107386673443) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 287.078299794842) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 300) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 300) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 121546.373651585) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 100000) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 223057.741749908) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 100000) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.45154665083435) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.206758060224) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 2.57657653270459) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.14614215827163) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 1.45154665083435E-02) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 0.01206758060224) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 2.57657653270459E-02) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 2.56669393257306E-02) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 998.794738783831) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 999.256685197423) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 996.611581661662) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 996.556340388894) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_AIR_4C" + CRLF + CRLF
  
  txt = txt + "liq_air_h_si(0, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 0, 0.5, 100, 100000), 26898.5215491787) + CRLF
  txt = txt + "liq_air_h_si(1, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 0, 0, 0.5, 100, 100000), -1681.79366112978) + CRLF
  txt = txt + "liq_air_h_si(0, 1, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 1, 0, 0.5, 100, 100000), 280.393544898538) + CRLF
  txt = txt + "liq_air_h_si(0, 0, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 1, 0.5, 100, 100000), 0.406872930019273) + CRLF
  txt = txt + "liq_air_h_si(2, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(2, 0, 0, 0.5, 100, 100000), 35.7689708914729) + CRLF
  txt = txt + "liq_air_h_si(1, 1, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 1, 0, 0.5, 100, 100000), 1.78599925195513) + CRLF
  txt = txt + "liq_air_h_si(1, 0, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 0, 1, 0.5, 100, 100000), 0.811745643965305) + CRLF
  txt = txt + "liq_air_h_si(0, 2, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 2, 0, 0.5, 100, 100000), 8.91776656829876E-02) + CRLF
  txt = txt + "liq_air_h_si(0, 1, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 1, 1, 0.5, 100, 100000), 1.55067379031342E-04) + CRLF
  txt = txt + "liq_air_h_si(0, 0, 2, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 2, 0.5, 100, 100000), -3.83770118469693E-06) + CRLF
  txt = txt + CRLF
  txt = txt + "liq_air_pottemp_si(0.5, 300, 1E4, 1E5)     =" + TwoCols(liq_air_pottemp_si(0.5, 300, 10000, 100000), 348.222379216949) + CRLF
  txt = txt + "liq_air_potdensity_si(0.5, 300, 1E4, 1E5)  =" + TwoCols(liq_air_potdensity_si(0.5, 300, 10000, 100000), 1.22550664944784) + CRLF
  txt = txt + "liq_air_potenthalpy_si(0.5, 300, 1E4, 1E5) =" + TwoCols(liq_air_potenthalpy_si(0.5, 300, 10000, 100000), 655155.797981886) + CRLF
  txt = txt + "liq_air_h_temperature_si(0.5, 100, 1E5)    =" + TwoCols(liq_air_h_temperature_si(0.5, 100, 100000), 280.393544898538) + CRLF
  txt = txt + "liq_air_h_lapserate_si(0.5, 100, 1E5)      =" + TwoCols(liq_air_h_lapserate_si(0.5, 100, 100000), 1.55067379031342E-04) + CRLF
  txt = txt + "liq_air_h_cp_si(0.5, 100, 1E5)             =" + TwoCols(liq_air_h_cp_si(0.5, 100, 100000), 3144.21265404382) + CRLF
  txt = txt + "liq_air_h_kappa_s_si(0.5, 100, 1E5)        =" + TwoCols(liq_air_h_kappa_s_si(0.5, 100, 100000), 9.43218607469204E-06) + CRLF
  txt = txt + "liq_air_h_density_si(0.5, 100, 1E5)        =" + TwoCols(liq_air_h_density_si(0.5, 100, 100000), 2.45776980039599) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_ICE_AIR_4" + CRLF + CRLF
  
  txt = txt + "liq_ice_air_ifl_si(.99, 100) =" + TwoCols(liq_ice_air_ifl_si(0.99, 100), 83234.7314360022) + CRLF
  txt = txt + "liq_ice_air_iml_si(.99, 100) =" + TwoCols(liq_ice_air_iml_si(0.99, 100), 81605.5557727816) + CRLF
  txt = txt + CRLF
  
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 0) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 3496.16306902868) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 7356.1294372357) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 900361.135280164) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 7.7475797940365) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 474.974398768669) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 38338.9622423812) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 10000) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 67931.6010763921) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 112016.075795051) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 706.817425300617) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.99) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.961024307543784) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.994366063923088) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.996583352944083) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.2) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 0.99) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 0.1) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 3.30296152581446E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 0.3) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 3.30296152581446E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 0.2) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 3.39407694837108E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 0.4) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.157198087326) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.159302793328) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.155) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5:  liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.151724970113) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.159992933078) + CRLF
  txt = txt + CRLF + CRLF

Else

  'SIA Version 1.0:
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  '!RESULTS CORRESPONDING TO VERSION 1.0 (V1.0)
  '!NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  '!MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  '!THE PORTION OF THE CODE BELOW (FROM HERE TO ENDIF) WILL ONLY BE ACTIVATED IF
  '!YOU CHANGE TO VERSION 1.0 (V1.0) IN CONSTANTS_0
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_AIR_4A" + CRLF + CRLF
  
  txt = txt + "liq_air_massfraction_air_si(300, 1E5)      =" + TwoCols(liq_air_massfraction_air_si(300, 100000), 0.977600623581678) + CRLF
  txt = txt + "liq_air_dewpoint_si(0.99, 1E5)             =" + TwoCols(liq_air_dewpoint_si(0.99, 100000), 287.074721926982) + CRLF
  txt = txt + "liq_air_ict_si(0.99, 300, 1E5)             =" + TwoCols(liq_air_ict_si(0.99, 300, 100000), 284.195916824567) + CRLF
  txt = txt + "liq_air_icl_si(0.99, 300, 1E5)             =" + TwoCols(liq_air_icl_si(0.99, 300, 100000), 82719.2377442223) + CRLF
  txt = txt + "liq_air_condensationpressure_si(0.9, 300) =" + TwoCols(liq_air_condensationpressure_si(0.9, 300), 23385.9346276043) + CRLF
  txt = txt + CRLF
  txt = txt + "liq_air_rh_cct_from_a_si(0.99, 300, 1E5)   =" + TwoCols(liq_air_rh_cct_from_a_si(0.99, 300, 100000), 0.449783278144408) + CRLF
  txt = txt + "liq_air_rh_wmo_from_a_si(0.99, 300, 1E5)   =" + TwoCols(liq_air_rh_wmo_from_a_si(0.99, 300, 100000), 0.440849494608027) + CRLF
  txt = txt + "liq_air_a_from_rh_wmo_si(0.8, 300, 1E5)    =" + TwoCols(liq_air_a_from_rh_wmo_si(0.8, 300, 100000), 0.981999860485227) + CRLF
  txt = txt + "liq_air_a_from_rh_cct_si(0.8, 300, 1E5)    =" + TwoCols(liq_air_a_from_rh_cct_si(0.8, 300, 100000), 0.982129130677262) + CRLF
  txt = txt + CRLF
  
  txt = txt + "liq_air_g_si(0, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 0, 0.5, 300, 100000), -5397.43216341774) + CRLF
  txt = txt + "liq_air_g_si(1, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 0, 0, 0.5, 300, 100000), -264.763415291866) + CRLF
  txt = txt + "liq_air_g_si(0, 1, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 1, 0, 0.5, 300, 100000), -343.818233767934) + CRLF
  txt = txt + "liq_air_g_si(0, 0, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 1, 0.5, 300, 100000), 0.446835172414366) + CRLF
  txt = txt + "liq_air_g_si(2, 0, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(2, 0, 0, 0.5, 300, 100000), 0) + CRLF
  txt = txt + "liq_air_g_si(1, 1, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 1, 0, 0.5, 300, 100000), 98.4884000932715) + CRLF
  txt = txt + "liq_air_g_si(1, 0, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(1, 0, 1, 0.5, 300, 100000), 0.891663433709969) + CRLF
  txt = txt + "liq_air_g_si(0, 2, 0, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 2, 0, 0.5, 300, 100000), -14.1012539815792) + CRLF
  txt = txt + "liq_air_g_si(0, 1, 1, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 1, 1, 0.5, 300, 100000), 2.43241086431687E-03) + CRLF
  txt = txt + "liq_air_g_si(0, 0, 2, 0.5, 300, 1E5) =" + TwoCols(liq_air_g_si(0, 0, 2, 0.5, 300, 100000), -4.6246973798681E-06) + CRLF
  txt = txt + CRLF
  
  txt = txt + "liq_air_liquidfraction_si(0.5, 300, 1E5) =" + TwoCols(liq_air_liquidfraction_si(0.5, 300, 100000), 0.488543697764709) + CRLF
  txt = txt + "liq_air_vapourfraction_si(0.5, 300, 1E5) =" + TwoCols(liq_air_vapourfraction_si(0.5, 300, 100000), 1.14563022352915E-02) + CRLF
  txt = txt + "liq_air_g_cp_si(0.5, 300, 1E5)           =" + TwoCols(liq_air_g_cp_si(0.5, 300, 100000), 4230.37619447375) + CRLF
  txt = txt + "liq_air_g_density_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_density_si(0.5, 300, 100000), 2.23796169535344) + CRLF
  txt = txt + "liq_air_g_entropy_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_entropy_si(0.5, 300, 100000), 343.818233767934) + CRLF
  txt = txt + "liq_air_g_expansion_si(0.5, 300, 1E5)    =" + TwoCols(liq_air_g_expansion_si(0.5, 300, 100000), 5.44364234170271E-03) + CRLF
  txt = txt + "liq_air_g_kappa_t_si(0.5, 300, 1E5)      =" + TwoCols(liq_air_g_kappa_t_si(0.5, 300, 100000), 1.03498955887462E-05) + CRLF
  txt = txt + "liq_air_g_lapserate_si(0.5, 300, 1E5)    =" + TwoCols(liq_air_g_lapserate_si(0.5, 300, 100000), 1.724960679025E-04) + CRLF
  txt = txt + CRLF
  
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2458132.60499966) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2465665.32463613) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2433111.45416375) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_enthalpy_evap_si =" + TwoCols(liq_air_enthalpy_evap_si, 2434585.86629587) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 100) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 145.864613600418) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, -42.0969943912465) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_entropy_air_si   =" + TwoCols(liq_air_entropy_air_si, 296.780112467825) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 290.10306942911) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 287.074721926982) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 300) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_temperature_si   =" + TwoCols(liq_air_temperature_si, 300) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 121541.303926767) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 100000) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 223109.793431746) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_pressure_si      =" + TwoCols(liq_air_pressure_si, 100000) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.45116943913412) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.20649187940702) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 2.57657751338532) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_air_si   =" + TwoCols(liq_air_density_air_si, 1.14587677779855) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 1.45116943913412E-02) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 1.20649187940703E-02) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 2.57657751338532E-02) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_vap_si   =" + TwoCols(liq_air_density_vap_si, 2.56669252749238E-02) + CRLF
  set_liq_air_eq_at_a_eta 0.99, 100
  txt = txt + "set_liq_air_eq_at_a_eta 0.99, 100:  liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 998.795484566385) + CRLF
  set_liq_air_eq_at_a_p 0.99, 100000
  txt = txt + "set_liq_air_eq_at_a_p 0.99, 100000: liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 999.257178498591) + CRLF
  set_liq_air_eq_at_a_t 0.99, 300
  txt = txt + "set_liq_air_eq_at_a_t 0.99, 300:    liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 996.611605024888) + CRLF
  set_liq_air_eq_at_t_p 300, 100000
  txt = txt + "set_liq_air_eq_at_t_p 300, 100000:  liq_air_density_liq_si   =" + TwoCols(liq_air_density_liq_si, 996.556340388894) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_AIR_4C" + CRLF + CRLF
  
  txt = txt + "liq_air_h_si(0, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 0, 0.5, 100, 100000), 26898.2871261607) + CRLF
  txt = txt + "liq_air_h_si(1, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 0, 0, 0.5, 100, 100000), -1682.2814754215) + CRLF
  txt = txt + "liq_air_h_si(0, 1, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 1, 0, 0.5, 100, 100000), 280.392597112172) + CRLF
  txt = txt + "liq_air_h_si(0, 0, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 1, 0.5, 100, 100000), 0.406967545474776) + CRLF
  txt = txt + "liq_air_h_si(2, 0, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(2, 0, 0, 0.5, 100, 100000), 35.66504361941) + CRLF
  txt = txt + "liq_air_h_si(1, 1, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 1, 0, 0.5, 100, 100000), 1.78333840654336) + CRLF
  txt = txt + "liq_air_h_si(1, 0, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(1, 0, 1, 0.5, 100, 100000), 0.811934874970271) + CRLF
  txt = txt + "liq_air_h_si(0, 2, 0, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 2, 0, 0.5, 100, 100000), 8.91712318142741E-02) + CRLF
  txt = txt + "liq_air_h_si(0, 1, 1, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 1, 1, 0.5, 100, 100000), 1.55091234445055E-04) + CRLF
  txt = txt + "liq_air_h_si(0, 0, 2, 0.5, 100, 1E5) =" + TwoCols(liq_air_h_si(0, 0, 2, 0.5, 100, 100000), -3.83855233558049E-06) + CRLF
  txt = txt + CRLF
  txt = txt + "liq_air_pottemp_si(0.5, 300, 1E4, 1E5)     =" + TwoCols(liq_air_pottemp_si(0.5, 300, 10000, 100000), 348.223146077119) + CRLF
  txt = txt + "liq_air_potdensity_si(0.5, 300, 1E4, 1E5)  =" + TwoCols(liq_air_potdensity_si(0.5, 300, 10000, 100000), 1.22518908856086) + CRLF
  txt = txt + "liq_air_potenthalpy_si(0.5, 300, 1E4, 1E5) =" + TwoCols(liq_air_potenthalpy_si(0.5, 300, 10000, 100000), 655299.468706051) + CRLF
  txt = txt + "liq_air_h_temperature_si(0.5, 100, 1E5)    =" + TwoCols(liq_air_h_temperature_si(0.5, 100, 100000), 280.392597112172) + CRLF
  txt = txt + "liq_air_h_lapserate_si(0.5, 100, 1E5)      =" + TwoCols(liq_air_h_lapserate_si(0.5, 100, 100000), 1.55091234445055E-04) + CRLF
  txt = txt + "liq_air_h_cp_si(0.5, 100, 1E5)             =" + TwoCols(liq_air_h_cp_si(0.5, 100, 100000), 3144.42888594579) + CRLF
  txt = txt + "liq_air_h_kappa_s_si(0.5, 100, 1E5)        =" + TwoCols(liq_air_h_kappa_s_si(0.5, 100, 100000), 9.43208464228361E-06) + CRLF
  txt = txt + "liq_air_h_density_si(0.5, 100, 1E5)        =" + TwoCols(liq_air_h_density_si(0.5, 100, 100000), 2.4571983960868) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_ICE_AIR_4" + CRLF + CRLF
  
  txt = txt + "liq_ice_air_ifl_si(.99, 100) =" + TwoCols(liq_ice_air_ifl_si(0.99, 100), 83240.7163329918) + CRLF
  txt = txt + "liq_ice_air_iml_si(.99, 100) =" + TwoCols(liq_ice_air_iml_si(0.99, 100), 81612.0101048005) + CRLF
  txt = txt + CRLF
  
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_entropy_si         =" + TwoCols(liq_ice_air_entropy_si, 0) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_entropy_si        =" + TwoCols(liq_ice_air_entropy_si, 3496.20368786436) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_enthalpy_si        =" + TwoCols(liq_ice_air_enthalpy_si, 7358.21843392192) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_enthalpy_si       =" + TwoCols(liq_ice_air_enthalpy_si, 900361.142093772) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_density_si         =" + TwoCols(liq_ice_air_density_si, 7.74649959201826) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_density_si        =" + TwoCols(liq_ice_air_density_si, 474.974398771744) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 38347.8983146684) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 10000) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 67931.6010763921) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_pressure_si        =" + TwoCols(liq_ice_air_pressure_si, 112016.572991626) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_pressure_si       =" + TwoCols(liq_ice_air_pressure_si, 706.839968365434) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.99) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.961015437340699) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.994364739825772) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_airfraction_si     =" + TwoCols(liq_ice_air_airfraction_si, 0.996582564510175) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_airfraction_si    =" + TwoCols(liq_ice_air_airfraction_si, 0.2) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_dryairfraction_si  =" + TwoCols(liq_ice_air_dryairfraction_si, 0.99) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_dryairfraction_si =" + TwoCols(liq_ice_air_dryairfraction_si, 0.1) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_solidfraction_si   =" + TwoCols(liq_ice_air_solidfraction_si, 3.30256857012676E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_solidfraction_si  =" + TwoCols(liq_ice_air_solidfraction_si, 0.3) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_liquidfraction_si  =" + TwoCols(liq_ice_air_liquidfraction_si, 3.30256857012676E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_liquidfraction_si =" + TwoCols(liq_ice_air_liquidfraction_si, 0.2) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 9.99999999E+98) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_vapourfraction_si  =" + TwoCols(liq_ice_air_vapourfraction_si, 3.3948628597465E-03) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_vapourfraction_si =" + TwoCols(liq_ice_air_vapourfraction_si, 0.4) + CRLF
  set_liq_ice_air_eq_at_a 0.99
  txt = txt + "set_liq_ice_air_eq_at_a 0.99:                  liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.157197423614) + CRLF
  set_liq_ice_air_eq_at_p 10000
  txt = txt + "set_liq_ice_air_eq_at_p 10000:                 liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.159302793328) + CRLF
  set_liq_ice_air_eq_at_t 273.155
  txt = txt + "set_liq_ice_air_eq_at_t 273.155:               liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.155) + CRLF
  set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5
  txt = txt + "set_liq_ice_air_eq_at_wa_eta_wt 0.99, 0, 0.5: liq_ice_air_temperature_si     =" + TwoCols(liq_ice_air_temperature_si, 273.151724933173) + CRLF
  set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3
  txt = txt + "set_liq_ice_air_eq_at_wa_wl_wi 0.1, 0.2, 0.3:  liq_ice_air_temperature_si    =" + TwoCols(liq_ice_air_temperature_si, 273.159992931404) + CRLF
  txt = txt + CRLF + CRLF

End If

txt = txt + "COMPARISON OF CHECK VALUES FROM LIQ_VAP_4" + CRLF + CRLF

txt = txt + "liq_vap_vapourpressure_si(300)                      =" + TwoCols(liq_vap_vapourpressure_si(300), 3536.80675227417) + CRLF
txt = txt + "liq_vap_boilingtemperature_si(1E4)                  =" + TwoCols(liq_vap_boilingtemperature_si(10000), 318.956328923936) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_pressure_vap_si  =" + TwoCols(liq_vap_pressure_vap_si, 3536.80675227417) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_pressure_vap_si  =" + TwoCols(liq_vap_pressure_vap_si, 10000) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_pressure_liq_si  =" + TwoCols(liq_vap_pressure_liq_si, 3536.80674986979) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_pressure_liq_si  =" + TwoCols(liq_vap_pressure_liq_si, 9999.99999853165) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_temperature_si   =" + TwoCols(liq_vap_temperature_si, 300) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_temperature_si   =" + TwoCols(liq_vap_temperature_si, 318.956328923936) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_chempot_si       =" + TwoCols(liq_vap_chempot_si, -5361.84908682075) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_chempot_si       =" + TwoCols(liq_vap_chempot_si, -15259.1024273131) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_density_liq_si   =" + TwoCols(liq_vap_density_liq_si, 996.513027468131) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_density_liq_si   =" + TwoCols(liq_vap_density_liq_si, 989.833275364924) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_density_vap_si   =" + TwoCols(liq_vap_density_vap_si, 2.55896736829199E-02) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_density_vap_si   =" + TwoCols(liq_vap_density_vap_si, 6.81657223094408E-02) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_entropy_liq_si   =" + TwoCols(liq_vap_entropy_liq_si, 393.089029801268) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_entropy_liq_si   =" + TwoCols(liq_vap_entropy_liq_si, 649.195605195818) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_entropy_vap_si   =" + TwoCols(liq_vap_entropy_vap_si, 8517.38650060567) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_entropy_vap_si   =" + TwoCols(liq_vap_entropy_vap_si, 8148.82019424941) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_enthalpy_liq_si  =" + TwoCols(liq_vap_enthalpy_liq_si, 112564.859853558) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_enthalpy_liq_si  =" + TwoCols(liq_vap_enthalpy_liq_si, 191805.944559497) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_enthalpy_vap_si  =" + TwoCols(liq_vap_enthalpy_vap_si, 2549854.10109488) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_enthalpy_vap_si  =" + TwoCols(liq_vap_enthalpy_vap_si, 2583858.67179171) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_volume_evap_si   =" + TwoCols(liq_vap_volume_evap_si, 39.0772595686141) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_volume_evap_si   =" + TwoCols(liq_vap_volume_evap_si, 14.6691196140812) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_entropy_evap_si  =" + TwoCols(liq_vap_entropy_evap_si, 8124.29747080441) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_entropy_evap_si  =" + TwoCols(liq_vap_entropy_evap_si, 7499.62458905359) + CRLF
txt = txt + CRLF

set_liq_vap_eq_at_t 300
txt = txt + "set_liq_vap_eq_at_t 300:   liq_vap_enthalpy_evap_si =" + TwoCols(liq_vap_enthalpy_evap_si, 2437289.24124132) + CRLF
set_liq_vap_eq_at_p 10000
txt = txt + "set_liq_vap_eq_at_p 10000: liq_vap_enthalpy_evap_si =" + TwoCols(liq_vap_enthalpy_evap_si, 2392052.72723222) + CRLF
txt = txt + CRLF + CRLF

If Molar_mass_air_L2000 = Molar_mass_air_si Then

  'SIA Version 1.1:
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  'RESULTS CORRESPONDING TO VERSION 1.1 (V. 1.1)
  'NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  'MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  'THE PORTION OF THE CODE BELOW (FROM HERE TO ELSEIF) USES THIS VALUE OF THE MOLAR MASS.
  'TO USES THE ORIGINAL VALUE USED BY LEMMON ET AL. (2000) YOU MUST EDIT CONSTANTS_0 TO
  'CORRESPOND TO VERSION 1.0 (v. 1.0).
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_AIR_4" + CRLF + CRLF
  
  txt = txt + "sea_air_massfraction_air_si(0.035, 300, 1E5) =" + TwoCols(sea_air_massfraction_air_si(0.035, 300#, 100000#), 0.978029483888009) + CRLF
  txt = txt + "sea_air_vapourpressure_si(0.035, 300, 1E5)   =" + TwoCols(sea_air_vapourpressure_si(0.035, 300#, 100000#), 3485.92986681407) + CRLF
  txt = txt + "sea_air_chempot_evap_si(0.9,0.035,300,1E5)   =" + TwoCols(sea_air_chempot_evap_si(0.9, 0.035, 300, 100000#), 1.45584069070883) + CRLF
  txt = txt + "sea_air_entropy_air_si(0.035, 300, 1E5)      =" + TwoCols(sea_air_entropy_air_si(0.035, 300#, 100000#), 293.15067295733) + CRLF
  txt = txt + "sea_air_condense_temp_si(0.035, 0.99, 1E5)   =" + TwoCols(sea_air_condense_temp_si(0.035, 0.99, 100000#), 287.367456467663) + CRLF
  txt = txt + CRLF
  
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_enthalpy_evap_si =" + TwoCols(sea_air_enthalpy_evap_si, 2464738.79136465) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_enthalpy_evap_si =" + TwoCols(sea_air_enthalpy_evap_si, 2434549.89769804) + CRLF
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_density_air_si   =" + TwoCols(sea_air_density_air_si, 1.20553988597722) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_density_air_si   =" + TwoCols(sea_air_density_air_si, 1.14642944447943) + CRLF
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_density_vap_si   =" + TwoCols(sea_air_density_vap_si, 1.20553988597722E-02) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_density_vap_si   =" + TwoCols(sea_air_density_vap_si, 2.51876465811967E-02) + CRLF
  txt = txt + CRLF + CRLF

Else

  'SIA Version 1.0:
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  '!RESULTS CORRESPONDING TO VERSION 1.0 (V1.0)
  '!NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  '!MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  '!THE PORTION OF THE CODE BELOW (FROM HERE TO ENDIF) WILL ONLY BE ACTIVATED IF
  '!YOU CHANGE TO VERSION 1.0 (V1.0) IN CONSTANTS_0
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_AIR_4" + CRLF + CRLF
  
  txt = txt + "sea_air_massfraction_air_si(0.035, 300, 1E5) =" + TwoCols(sea_air_massfraction_air_si(0.035, 300#, 100000#), 0.97802440543935) + CRLF
  txt = txt + "sea_air_vapourpressure_si(0.035, 300, 1E5)   =" + TwoCols(sea_air_vapourpressure_si(0.035, 300#, 100000#), 3485.92802425416) + CRLF
  txt = txt + "sea_air_chempot_evap_si(0.9,0.035,300,1E5)   =" + TwoCols(sea_air_chempot_evap_si(0.9, 0.035, 300, 100000#), 1.45564492466977) + CRLF
  txt = txt + "sea_air_entropy_air_si(0.035, 300, 1E5)      =" + TwoCols(sea_air_entropy_air_si(0.035, 300#, 100000#), 293.218508134414) + CRLF
  txt = txt + "sea_air_condense_temp_si(0.035, 0.99, 1E5)   =" + TwoCols(sea_air_condense_temp_si(0.035, 0.99, 100000#), 287.363869940874) + CRLF
  txt = txt + CRLF
  
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_enthalpy_evap_si =" + TwoCols(sea_air_enthalpy_evap_si, 2464747.68964351) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_enthalpy_evap_si =" + TwoCols(sea_air_enthalpy_evap_si, 2434550.22477297) + CRLF
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_density_air_si   =" + TwoCols(sea_air_density_air_si, 1.20527399511464) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_density_air_si   =" + TwoCols(sea_air_density_air_si, 1.14616388271098) + CRLF
  set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000
  txt = txt + "set_sea_air_eq_at_s_a_p 0.035, 0.99, 100000: sea_air_density_vap_si   =" + TwoCols(sea_air_density_vap_si, 1.20527399511464E-02) + CRLF
  set_sea_air_eq_at_s_t_p 0.035, 300, 100000
  txt = txt + "set_sea_air_eq_at_s_t_p 0.035, 300, 100000:  sea_air_density_vap_si   =" + TwoCols(sea_air_density_vap_si, 0.025187632786517) + CRLF
  txt = txt + CRLF + CRLF

End If

txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_VAP_4" + CRLF + CRLF

txt = txt + "sea_vap_boilingtemperature_si(0.035,640)     =" + TwoCols(sea_vap_boilingtemperature_si(0.035, 640), 274.042416829483) + CRLF
txt = txt + "sea_vap_cp_seavap_si(0.035,274,610)          =" + TwoCols(sea_vap_cp_seavap_si(0.035, 274, 610), 756270.431593252) + CRLF
txt = txt + "sea_vap_density_seavap_si(0.035, 274, 610)   =" + TwoCols(sea_vap_density_seavap_si(0.035, 274, 610), 7.2709278688204E-03) + CRLF
txt = txt + "sea_vap_enthalpy_seavap_si(0.035, 274, 610)  =" + TwoCols(sea_vap_enthalpy_seavap_si(0.035, 274, 610), 1661118.41089021) + CRLF
txt = txt + "sea_vap_entropy_seavap_si(0.035, 274, 610)   =" + TwoCols(sea_vap_entropy_seavap_si(0.035, 274, 610), 6072.50817708997) + CRLF
txt = txt + "sea_vap_expansion_seavap_si(0.035, 274, 610) =" + TwoCols(sea_vap_expansion_seavap_si(0.035, 274, 610), 0.458863421346531) + CRLF
txt = txt + "sea_vap_kappa_t_seavap_si(0.035, 274, 610)   =" + TwoCols(sea_vap_kappa_t_seavap_si(0.035, 274, 610), 1.19990585450986E-02) + CRLF
txt = txt + "sea_vap_vapourpressure_si(0.035, 274)        =" + TwoCols(sea_vap_vapourpressure_si(0.035, 274), 638.044692614776) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_density_sea_si   =" + TwoCols(sea_vap_density_sea_si, 1027.87349555845) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_density_sea_si   =" + TwoCols(sea_vap_density_sea_si, 1027.87626132072) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_density_sea_si   =" + TwoCols(sea_vap_density_sea_si, 1023.42713046839) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_density_vap_si   =" + TwoCols(sea_vap_density_vap_si, 5.06324890263994E-03) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_density_vap_si   =" + TwoCols(sea_vap_density_vap_si, 5.04855547810571E-03) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_density_vap_si   =" + TwoCols(sea_vap_density_vap_si, 5.06403699512862E-03) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_enthalpy_evap_si =" + TwoCols(sea_vap_enthalpy_evap_si, 2498295.3218674) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_enthalpy_evap_si =" + TwoCols(sea_vap_enthalpy_evap_si, 2498395.40100976) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_enthalpy_evap_si =" + TwoCols(sea_vap_enthalpy_evap_si, 2498551.1987509) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_enthalpy_sea_si  =" + TwoCols(sea_vap_enthalpy_sea_si, 3465.11896144269) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_enthalpy_sea_si  =" + TwoCols(sea_vap_enthalpy_sea_si, 3295.96629298726) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_enthalpy_sea_si  =" + TwoCols(sea_vap_enthalpy_sea_si, 3405.93353729608) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_enthalpy_vap_si  =" + TwoCols(sea_vap_enthalpy_vap_si, 2502546.89357828) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_enthalpy_vap_si  =" + TwoCols(sea_vap_enthalpy_vap_si, 2502469.07186831) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_enthalpy_vap_si  =" + TwoCols(sea_vap_enthalpy_vap_si, 2502466.96632615) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_entropy_sea_si   =" + TwoCols(sea_vap_entropy_sea_si, 13.0616891215168) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_entropy_sea_si   =" + TwoCols(sea_vap_entropy_sea_si, 12.4443983378267) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_entropy_sea_si   =" + TwoCols(sea_vap_entropy_sea_si, 14.0256815111694) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_entropy_vap_si   =" + TwoCols(sea_vap_entropy_vap_si, 9140.56256065021) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_entropy_vap_si   =" + TwoCols(sea_vap_entropy_vap_si, 9141.68990452172) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_entropy_vap_si   =" + TwoCols(sea_vap_entropy_vap_si, 9140.27087792674) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_pressure_si      =" + TwoCols(sea_vap_pressure_si, 640) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_pressure_si      =" + TwoCols(sea_vap_pressure_si, 638.044692614776) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_pressure_si      =" + TwoCols(sea_vap_pressure_si, 640) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_salinity_si      =" + TwoCols(sea_vap_salinity_si, 0.035) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_salinity_si      =" + TwoCols(sea_vap_salinity_si, 0.035) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_salinity_si      =" + TwoCols(sea_vap_salinity_si, 2.94396298293595E-02) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_temperature_si   =" + TwoCols(sea_vap_temperature_si, 274.042416829483) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_temperature_si   =" + TwoCols(sea_vap_temperature_si, 274) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_temperature_si   =" + TwoCols(sea_vap_temperature_si, 274) + CRLF
txt = txt + CRLF

set_sea_vap_eq_at_s_p 0.035, 640
txt = txt + "set_sea_vap_eq_at_s_p 0.035, 640: sea_vap_volume_evap_si   =" + TwoCols(sea_vap_volume_evap_si, 197.500648109577) + CRLF
set_sea_vap_eq_at_s_t 0.035, 274
txt = txt + "set_sea_vap_eq_at_s_t 0.035, 274: sea_vap_volume_evap_si   =" + TwoCols(sea_vap_volume_evap_si, 198.075461154363) + CRLF
set_sea_vap_eq_at_t_p 274, 640
txt = txt + "set_sea_vap_eq_at_t_p 274, 640:   sea_vap_volume_evap_si   =" + TwoCols(sea_vap_volume_evap_si, 197.469911653041) + CRLF
txt = txt + CRLF

txt = txt + "sea_vap_g_si( 0, 0, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 0, 0, 0.035, 274, 610), -2748.82963244656) + CRLF
txt = txt + "sea_vap_g_si( 1, 0, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(1, 0, 0, 0.035, 274, 610), 151028.257424141) + CRLF
txt = txt + "sea_vap_g_si( 0, 1, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 1, 0, 0.035, 274, 610), -6072.50817708997) + CRLF
txt = txt + "sea_vap_g_si( 0, 0, 1, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 0, 1, 0.035, 274, 610), 137.534028399354) + CRLF
txt = txt + "sea_vap_g_si( 2, 0, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(2, 0, 0, 0.035, 274, 610), 0) + CRLF
txt = txt + "sea_vap_g_si( 1, 1, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(1, 1, 0, 0.035, 274, 610), 14965.0677010982) + CRLF
txt = txt + "sea_vap_g_si( 1, 0, 1, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(1, 0, 1, 0.035, 274, 610), -321.591932572033) + CRLF
txt = txt + "sea_vap_g_si( 0, 2, 0, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 2, 0, 0.035, 274, 610), -2760.11106420895) + CRLF
txt = txt + "sea_vap_g_si( 0, 1, 1, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 1, 1, 0.035, 274, 610), 63.1093348228985) + CRLF
txt = txt + "sea_vap_g_si( 0, 0, 2, 0.035, 274, 610) =" + TwoCols(sea_vap_g_si(0, 0, 2, 0.035, 274, 610), -1.6502788587071) + CRLF
txt = txt + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_LIQ_4" + CRLF + CRLF

txt = txt + "sea_liq_osmoticpressure_si(0.035, 300, 1E5) =" + TwoCols(sea_liq_osmoticpressure_si(0.035, 300#, 100000#), 2594603.20968294) + CRLF
txt = txt + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_ICE_4" + CRLF + CRLF

txt = txt + "sea_ice_brinesalinity_si(270, 1E5)               =" + TwoCols(sea_ice_brinesalinity_si(270, 100000), 0.056026415032218) + CRLF
txt = txt + "sea_ice_brinefraction_seaice_si(0.035, 270, 1E5) =" + TwoCols(sea_ice_brinefraction_seaice_si(0.035, 270, 100000), 0.624705328368293) + CRLF
txt = txt + "sea_ice_meltingpressure_si(0.035, 270)           =" + TwoCols(sea_ice_meltingpressure_si(0.035, 270), 16132047.4384824) + CRLF
txt = txt + "sea_ice_freezingtemperature_si(0.035, 1E5)       =" + TwoCols(sea_ice_freezingtemperature_si(0.035, 100000), 271.240373585159) + CRLF
txt = txt + "sea_ice_dtfdp_si(0.035, 1E5)                      =" + TwoCols(sea_ice_dtfdp_si(0.035, 100000), 7.48210942878832E-08) + CRLF
txt = txt + "sea_ice_dtfds_si(0.035, 1E5)                      =" + TwoCols(sea_ice_dtfds_si(0.035, 100000), -56.8751336296247) + CRLF
txt = txt + "sea_ice_cp_seaice_si(0.035, 270, 1E5)            =" + TwoCols(sea_ice_cp_seaice_si(0.035, 270, 100000), 62868.901512635) + CRLF
txt = txt + "sea_ice_density_seaice_si(0.035,270,1E5)         =" + TwoCols(sea_ice_density_seaice_si(0.035, 270, 100000), 993.156434117286) + CRLF
txt = txt + "sea_ice_enthalpy_seaice_si(0.035, 270, 1E5)      =" + TwoCols(sea_ice_enthalpy_seaice_si(0.035, 270, 100000), -135534.287503283) + CRLF
txt = txt + "sea_ice_entropy_seaice_si(0.035, 270, 1E5)       =" + TwoCols(sea_ice_entropy_seaice_si(0.035, 270, 100000), -500.445444180504) + CRLF
txt = txt + "sea_ice_expansion_seaice_si(0.035, 270, 1E5)     =" + TwoCols(sea_ice_expansion_seaice_si(0.035, 270, 100000), -1.64731328738132E-02) + CRLF
txt = txt + "sea_ice_kappa_t_seaice_si(0.035, 270, 1E5)       =" + TwoCols(sea_ice_kappa_t_seaice_si(0.035, 270, 100000), 1.56513441347963E-09) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_density_ice_si   =" + TwoCols(sea_ice_density_ice_si, 917.000739687017) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_density_ice_si   =" + TwoCols(sea_ice_density_ice_si, 918.898527655119) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_density_ice_si   =" + TwoCols(sea_ice_density_ice_si, 917.181167191815) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_density_sea_si   =" + TwoCols(sea_ice_density_sea_si, 1028.05199645) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_density_sea_si   =" + TwoCols(sea_ice_density_sea_si, 1035.73670169174) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_density_sea_si   =" + TwoCols(sea_ice_density_sea_si, 1045.16805917549) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_enthalpy_melt_si =" + TwoCols(sea_ice_enthalpy_melt_si, 329942.976284916) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_enthalpy_melt_si =" + TwoCols(sea_ice_enthalpy_melt_si, 326829.393605264) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_enthalpy_melt_si =" + TwoCols(sea_ice_enthalpy_melt_si, 328249.119579055) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_volume_melt_si   =" + TwoCols(sea_ice_volume_melt_si, -9.10140854473048E-05) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_volume_melt_si   =" + TwoCols(sea_ice_volume_melt_si, -9.67135426847657E-05) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_volume_melt_si   =" + TwoCols(sea_ice_volume_melt_si, -9.1818691790039E-05) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_enthalpy_ice_si  =" + TwoCols(sea_ice_enthalpy_ice_si, -337351.999357552) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_enthalpy_ice_si  =" + TwoCols(sea_ice_enthalpy_ice_si, -323205.968289297) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_enthalpy_ice_si  =" + TwoCols(sea_ice_enthalpy_ice_si, -339929.55549867) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_enthalpy_sea_si  =" + TwoCols(sea_ice_enthalpy_sea_si, -7613.19337918826) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_enthalpy_sea_si  =" + TwoCols(sea_ice_enthalpy_sea_si, 2832.94910407065) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_enthalpy_sea_si  =" + TwoCols(sea_ice_enthalpy_sea_si, -12742.8664892136) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_entropy_ice_si   =" + TwoCols(sea_ice_entropy_ice_si, -1235.44872811514) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_entropy_ice_si   =" + TwoCols(sea_ice_entropy_ice_si, -1247.71314646436) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_entropy_ice_si   =" + TwoCols(sea_ice_entropy_ice_si, -1244.97335506441) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_entropy_sea_si   =" + TwoCols(sea_ice_entropy_sea_si, -27.9264598102728) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_entropy_sea_si   =" + TwoCols(sea_ice_entropy_sea_si, -46.7361169560176) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_entropy_sea_si   =" + TwoCols(sea_ice_entropy_sea_si, -53.166791114353) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_pressure_si      =" + TwoCols(sea_ice_pressure_si, 100000) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_pressure_si      =" + TwoCols(sea_ice_pressure_si, 16132047.4384824) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_pressure_si      =" + TwoCols(sea_ice_pressure_si, 100000) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_temperature_si   =" + TwoCols(sea_ice_temperature_si, 271.240373585159) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_temperature_si   =" + TwoCols(sea_ice_temperature_si, 270) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_temperature_si   =" + TwoCols(sea_ice_temperature_si, 270) + CRLF
txt = txt + CRLF

set_sea_ice_eq_at_s_p 0.035, 100000
txt = txt + "set_sea_ice_eq_at_s_p 0.035, 1E5: sea_ice_salinity_si      =" + TwoCols(sea_ice_salinity_si, 0.035) + CRLF
set_sea_ice_eq_at_s_t 0.035, 270
txt = txt + "set_sea_ice_eq_at_s_t 0.035, 270: sea_ice_salinity_si      =" + TwoCols(sea_ice_salinity_si, 0.035) + CRLF
set_sea_ice_eq_at_t_p 270, 100000
txt = txt + "set_sea_ice_eq_at_t_p 270, 1E5:   sea_ice_salinity_si      =" + TwoCols(sea_ice_salinity_si, 0.056026415032218) + CRLF
txt = txt + CRLF

txt = txt + "sea_ice_g_si( 0, 0, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 0, 0, 0.035, 270, 100000), -414.017574546827) + CRLF
txt = txt + "sea_ice_g_si( 1, 0, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(1, 0, 0, 0.035, 270, 100000), 96363.7730494649) + CRLF
txt = txt + "sea_ice_g_si( 0, 1, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 1, 0, 0.035, 270, 100000), 500.445444180504) + CRLF
txt = txt + "sea_ice_g_si( 0, 0, 1, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 0, 1, 0.035, 270, 100000), 1.00689072299954E-03) + CRLF
txt = txt + "sea_ice_g_si( 2, 0, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(2, 0, 0, 0.035, 270, 100000), 0) + CRLF
txt = txt + "sea_ice_g_si( 1, 1, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(1, 1, 0, 0.035, 270, 100000), -1144.02883418563) + CRLF
txt = txt + "sea_ice_g_si( 1, 0, 1, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(1, 0, 1, 0.035, 270, 100000), -8.62856321467455E-04) + CRLF
txt = txt + "sea_ice_g_si( 0, 2, 0, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 2, 0, 0.035, 270, 100000), -232.84778338013) + CRLF
txt = txt + "sea_ice_g_si( 0, 1, 1, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 1, 1, 0.035, 270, 100000), -1.65866446693812E-05) + CRLF
txt = txt + "sea_ice_g_si( 0, 0, 2, 0.035, 270, 1E5) =" + TwoCols(sea_ice_g_si(0, 0, 2, 0.035, 270, 100000), -1.57591932117997E-12) + CRLF
txt = txt + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FROM SEA_ICE_VAP_4" + CRLF + CRLF

set_sea_ice_vap_eq_at_s 0.035
txt = txt + "set_sea_ice_vap_eq_at_s 0.035: sea_ice_vap_salinity_si    =" + TwoCols(sea_ice_vap_salinity_si, 0.035) + CRLF
set_sea_ice_vap_eq_at_t 270
txt = txt + "set_sea_ice_vap_eq_at_t 270:   sea_ice_vap_salinity_si    =" + TwoCols(sea_ice_vap_salinity_si, 5.61489288505582E-02) + CRLF
set_sea_ice_vap_eq_at_p 500
txt = txt + "set_sea_ice_vap_eq_at_p 500:   sea_ice_vap_salinity_si    =" + TwoCols(sea_ice_vap_salinity_si, 4.38955878827614E-02) + CRLF
txt = txt + CRLF

set_sea_ice_vap_eq_at_s 0.035
txt = txt + "set_sea_ice_vap_eq_at_s 0.035: sea_ice_vap_density_vap_si =" + TwoCols(sea_ice_vap_density_vap_si, 4.17156419317765E-03) + CRLF
set_sea_ice_vap_eq_at_t 270
txt = txt + "set_sea_ice_vap_eq_at_t 270:   sea_ice_vap_density_vap_si =" + TwoCols(sea_ice_vap_density_vap_si, 3.7740614077202E-03) + CRLF
set_sea_ice_vap_eq_at_p 500
txt = txt + "set_sea_ice_vap_eq_at_p 500:   sea_ice_vap_density_vap_si =" + TwoCols(sea_ice_vap_density_vap_si, 4.00364833230323E-03) + CRLF
txt = txt + CRLF

set_sea_ice_vap_eq_at_s 0.035
txt = txt + "set_sea_ice_vap_eq_at_s 0.035: sea_ice_vap_temperature_si =" + TwoCols(sea_ice_vap_temperature_si, 271.247815056812) + CRLF
set_sea_ice_vap_eq_at_t 270
txt = txt + "set_sea_ice_vap_eq_at_t 270:   sea_ice_vap_temperature_si =" + TwoCols(sea_ice_vap_temperature_si, 270) + CRLF
set_sea_ice_vap_eq_at_p 500
txt = txt + "set_sea_ice_vap_eq_at_p 500:   sea_ice_vap_temperature_si =" + TwoCols(sea_ice_vap_temperature_si, 270.734430916974) + CRLF
txt = txt + CRLF

set_sea_ice_vap_eq_at_s 0.035
txt = txt + "set_sea_ice_vap_eq_at_s 0.035: sea_ice_vap_pressure_si    =" + TwoCols(sea_ice_vap_pressure_si, 521.950349224785) + CRLF
set_sea_ice_vap_eq_at_t 270
txt = txt + "set_sea_ice_vap_eq_at_t 270:   sea_ice_vap_pressure_si    =" + TwoCols(sea_ice_vap_pressure_si, 470.059067980885) + CRLF
set_sea_ice_vap_eq_at_p 500
txt = txt + "set_sea_ice_vap_eq_at_p 500:   sea_ice_vap_pressure_si    =" + TwoCols(sea_ice_vap_pressure_si, 500) + CRLF
txt = txt + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FROM ICE_FLU_5" + CRLF + CRLF

txt = txt + "fit_ice_liq_pressure_si(272.4)  =" + TwoCols(fit_ice_liq_pressure_si(272.4), 10021372.4736) + CRLF
txt = txt + "fit_ice_liq_temperature_si(1E7) =" + TwoCols(fit_ice_liq_temperature_si(10000000#), 272.401569225) + CRLF
txt = txt + "fit_ice_vap_pressure_si(270)    =" + TwoCols(fit_ice_vap_pressure_si(270), 470.061877574) + CRLF

mix_check_values = txt

End Function
