Attribute VB_Name = "Values_CNV_Mdl"
'THIS MODULE PROVIDES AN EASY WAY FOR THE USER TO COMPARE RESULTS FROM THE CONVERT ROUTINES
'RUN LOCALLY WITH THE CHECK VALUES PROVIDED IN THE VARIOUS ROUTINES

'THIS MODULE REQUIRES
'     CONSTANTS_0_Mdl, FILE CONSTANTS_0.bas
'     CONVERT_0_Mdl,   FILE CONVERT_0.bas
'     CONVERT_5_Mdl,   FILE CONVERT_5.bas
'     Maths_0_Mdl,     file Maths_0.bas

Option Explicit

Private Const Version = "23 Feb 2011"

'==========================================================================
Public Function cnv_check_values() As String
'==========================================================================

Dim txt As String, CRLF As String, TB As String

CRLF = Chr(13) + Chr(10)

txt = "COMPARISON OF CHECK VALUES FOR THE PRESSURE CONVERSION ROUTINE" + CRLF + CRLF

txt = txt + "cnv_pressure(""DBAR"",10331325,""PA"")            =" + TwoCols(cnv_pressure("DBAR", 10331325, "PA"), 1023) + CRLF
txt = txt + "cnv_pressure(""PA"",1023,""DBAR"")                =" + TwoCols(cnv_pressure("PA", 1023, "DBAR"), 10331325) + CRLF
txt = txt + "cnv_pressure(""TORR"",10331325,""PA"")            =" + TwoCols(cnv_pressure("TORR", 10331325, "PA"), 77491.3101406) + CRLF
txt = txt + "cnv_pressure(""PA"",0.774913101406E5,""TORR"")    =" + TwoCols(cnv_pressure("PA", 77491.3101406, "TORR"), 10331325) + CRLF
txt = txt + "cnv_pressure(""KGF"",10331325,""PA"")             =" + TwoCols(cnv_pressure("KGF", 10331325, "PA"), 105350.19604) + CRLF
txt = txt + "cnv_pressure(""PA"",0.105350196040E6,""KGF"")     =" + TwoCols(cnv_pressure("PA", 105350.19604, "KGF"), 10331325) + CRLF
txt = txt + "cnv_pressure(""ATM"",10331325,""PA"")             =" + TwoCols(cnv_pressure("ATM", 10331325, "PA"), 105350.19604) + CRLF
txt = txt + "cnv_pressure(""PA"",0.105350196040E6,""ATM"")     =" + TwoCols(cnv_pressure("PA", 105350.19604, "ATM"), 10331325) + CRLF
txt = txt + "cnv_pressure(""LBF/IN2"",10331325,""PA"")         =" + TwoCols(cnv_pressure("LBF/IN2", 10331325, "PA"), 1498.42272437) + CRLF
txt = txt + "cnv_pressure(""PA"",0.149842272437E4,""LBF/IN2"") =" + TwoCols(cnv_pressure("PA", 1498.42272437, "LBF/IN2"), 10331325) + CRLF
txt = txt + "cnv_pressure(""PSI"",10331325,""PA"")             =" + TwoCols(cnv_pressure("PSI", 10331325, "PA"), 1498.42272437) + CRLF
txt = txt + "cnv_pressure(""PA"",0.149842272437E4,""PSI"")     =" + TwoCols(cnv_pressure("PA", 1498.42272437, "PSI"), 10331325) + CRLF
txt = txt + "cnv_pressure(""M"",1023,""DBAR"")                 =" + TwoCols(cnv_pressure("M", 1023#, "DBAR"), 1011.94563591) + CRLF
txt = txt + "cnv_pressure(""DBAR"",1011.94563591,""M"")        =" + TwoCols(cnv_pressure("DBAR", 1011.94563591, "M"), 1023) + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FOR THE TEMPERATURE CONVERSION ROUTINE" + CRLF + CRLF

txt = txt + "cnv_temperature(""DEGF(T48)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGF(T48)", 300, "K(T48)"), 80.33) + CRLF
txt = txt + "cnv_temperature(""DEGF(T68)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGF(T68)", 300, "K(T48)"), 80.3139948157844) + CRLF
txt = txt + "cnv_temperature(""DEGF(T90)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGF(T90)", 300, "K(T48)"), 80.3018730496216) + CRLF
txt = txt + "cnv_temperature(""DEGC(T48)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGC(T48)", 300, "K(T48)"), 26.85) + CRLF
txt = txt + "cnv_temperature(""DEGC(T68)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGC(T68)", 300, "K(T48)"), 26.8411082312) + CRLF
txt = txt + "cnv_temperature(""DEGC(T90)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGC(T90)", 300, "K(T48)"), 26.8343739167) + CRLF
txt = txt + "cnv_temperature(""K(T68)"",300,""K(T48)"")              =" + TwoCols(cnv_temperature("K(T68)", 300, "K(T48)"), 299.991108231) + CRLF
txt = txt + "cnv_temperature(""K(T90)"",300,""K(T48)"")              =" + TwoCols(cnv_temperature("K(T90)", 300, "K(T48)"), 299.984373917) + CRLF
txt = txt + "cnv_temperature(""DEGF(T68)"",299.991108231,""K(T68)"") =" + TwoCols(cnv_temperature("DEGF(T68)", 299.991108231, "K(T68)"), 80.3139916337851) + CRLF
txt = txt + "cnv_temperature(""DEGF(T90)"",299.991108231,""K(T68)"") =" + TwoCols(cnv_temperature("DEGF(T90)", 299.991108231, "K(T68)"), 80.3018698684571) + CRLF
txt = txt + "cnv_temperature(""DEGC(T68)"",299.991108231,""K(T68)"") =" + TwoCols(cnv_temperature("DEGC(T68)", 299.991108231, "K(T68)"), 26.8411064632) + CRLF
txt = txt + "cnv_temperature(""DEGC(T90)"",299.991108231,""K(T68)"") =" + TwoCols(cnv_temperature("DEGC(T90)", 299.991108231, "K(T68)"), 26.8343721491) + CRLF
txt = txt + "cnv_temperature(""K(T90)"",299.991108231,""K(T68)"")    =" + TwoCols(cnv_temperature("K(T90)", 299.991108231, "K(T68)"), 299.984372149) + CRLF
txt = txt + "cnv_temperature(""DEGC(T48)"",300,""K(T48)"")           =" + TwoCols(cnv_temperature("DEGC(T48)", 300, "K(T48)"), 26.85) + CRLF
txt = txt + "cnv_temperature(""DEGF(T90)"",299.984372149,""K(T90)"") =" + TwoCols(cnv_temperature("DEGF(T90)", 299.984372149, "K(T90)"), 80.3018698682001) + CRLF + CRLF

txt = txt + "COMPARISON OF CHECK VALUES FOR THE SALINITY CONVERSION ROUTINE (modified in version 3.0)" + CRLF + CRLF

txt = txt + "cnv_salinity(""CL"",0.0357,""KG/KG(ABS)"",,101325+1023E4,201,-21)                    =" + TwoCols(cnv_salinity("CL", 0.0357, "KG/KG(ABS)", , 101325 + 10230000#, 201, -21), 19.6659461766504) + CRLF
txt = txt + "cnv_salinity(""KN"",0.0357,""KG/KG(ABS)"",,101325+1023E4,201,-21)                    =" + TwoCols(cnv_salinity("KN", 0.0357, "KG/KG(ABS)", , 101325 + 10230000#, 201, -21), 35.527032848854) + CRLF
txt = txt + "cnv_salinity(""CND"",0.0357,""KG/KG(ABS)"",273.15+25.5,101325+1023E4,201,-21)        =" + TwoCols(cnv_salinity("CND", 0.0357, "KG/KG(ABS)", 273.15 + 25.5, 101325 + 10230000#, 201, -21), 1.27556269127774) + CRLF
txt = txt + "cnv_salinity(""PSU"",0.0357,""KG/KG(ABS)"",,101325+1023E4,201,-21)                   =" + TwoCols(cnv_salinity("PSU", 0.0357, "KG/KG(ABS)", , 101325 + 10230000#, 201, -21), 35.5275150654278) + CRLF
txt = txt + "cnv_salinity(""KG/KG(REF)"",0.0357,""KG/KG(ABS)"",,101325+1023E4,201,-21)            =" + TwoCols(cnv_salinity("KG/KG(REF)", 0.0357, "KG/KG(ABS)", , 101325 + 10230000#, 201, -21), 3.56950425250392E-02) + CRLF
txt = txt + "cnv_salinity(""KG/KG(ABS)"",0.0356951724471,""KG/KG(REF)"",,101325+1023E4,201,-21)   =" + TwoCols(cnv_salinity("KG/KG(ABS)", 0.0356951724471, "KG/KG(REF)", , 101325 + 10230000#, 201, -21), 0.035700129940105) + CRLF
txt = txt + "cnv_salinity(""CL"",35.52764437773386,""PSU"",,101325+1023E4,201,-21)                =" + TwoCols(cnv_salinity("CL", 35.5276443777339, "PSU", , 101325 + 10230000#, 201, -21), 19.6660177563499) + CRLF
txt = txt + "cnv_salinity(""KN"",35.52764437773386,""PSU"",,101325+1023E4,201,-21)                =" + TwoCols(cnv_salinity("KN", 35.5276443777339, "PSU", , 101325 + 10230000#, 201, -21), 35.5271620502116) + CRLF
txt = txt + "cnv_salinity(""CND"",35.52764437773386,""PSU"",273.15+25.5,101325+1023E4,201,-21)    =" + TwoCols(cnv_salinity("CND", 35.5276443777339, "PSU", 273.15 + 25.5, 101325 + 10230000#, 201, -21), 1.27556680821579) + CRLF
txt = txt + "cnv_salinity(""KG/KG(REF)"",35.52764437773386,""PSU"",,101325+1023E4,201,-21)        =" + TwoCols(cnv_salinity("KG/KG(REF)", 35.5276443777339, "PSU", , 101325 + 10230000#, 201, -21), 3.56951724471082E-02) + CRLF
txt = txt + "cnv_salinity(""KG/KG(ABS)"",35.52764437773386,""PSU"",,101325+1023E4,201,-21)        =" + TwoCols(cnv_salinity("KG/KG(ABS)", 35.5276443777339, "PSU", , 101325 + 10230000#, 201, -21), 3.57001299401132E-02) + CRLF
txt = txt + "cnv_salinity(""PSU"",35.5271620502,""KN"")                                           =" + TwoCols(cnv_salinity("PSU", 35.5271620502, "KN"), 35.5276443777223) + CRLF
txt = txt + "cnv_salinity(""KG/KG(ABS)"",35.5271620502,""KN"",,101325+1023E4,201,-21)             =" + TwoCols(cnv_salinity("KG/KG(ABS)", 35.5271620502, "KN", , 101325 + 10230000#, 201, -21), 3.57001299401016E-02) + CRLF
txt = txt + "cnv_salinity(""PSU"",1.27540928136,""CND"",273.15+25.5,101325+1023E4,201,-21)        =" + TwoCols(cnv_salinity("PSU", 1.27540928136, "CND", 273.15 + 25.5, 101325 + 10230000#, 201, -21), 35.5226965418192) + CRLF
txt = txt + "cnv_salinity(""KG/KG(ABS)"",1.27556680822,""CND"",273.15+25.5,101325+1023E4,201,-21) =" + TwoCols(cnv_salinity("KG/KG(ABS)", 1.27556680822, "CND", 273.15 + 25.5, 101325 + 10230000#, 201, -21), 3.57001299402461E-02) + CRLF

txt = txt + CRLF + CRLF
txt = txt + "asal_from_psal(35.52764437773386, 201, -21, 101325+1023E4) =" + TwoCols(asal_from_psal(35.5276443777339, 201, -21, 101325 + 10230000#), 3.57001299401132E-02) + CRLF
txt = txt + "psal_from_asal(0.0357, 201, -21, 101325+1023E4)            =" + TwoCols(psal_from_asal(0.0357, 201, -21, 101325 + 10230000#), 35.5275150654278) + CRLF + CRLF

cnv_check_values = txt

End Function
