Attribute VB_Name = "Values_Air_Mdl"
'THIS MODULE PROVIDES AN EASY WAY FOR THE USER TO COMPARE RESULTS FROM THE AIR ROUTINES
'RUN LOCALLY WITH THE CHECK VALUES PROVIDED IN THE VARIOUS ROUTINES

'THIS MODULE REQUIRES
'     CONSTANTS_0,     FILE Constants_0.bas
'     CONVERT_0,       FILE CONVERT_0.BAS
'     Maths_0_Mdl,     file Maths_0.bas
'     AIR_1,           FILE AIR_1.BAS
'     AIR_2,           FILE AIR_2.BAS
'     AIR_3a,          FILE AIR_3a.BAS
'     AIR_3b,          FILE AIR_3b.BAS
'     AIR_3c,          FILE AIR_3c.BAS
 
Option Explicit

Private Const Version = "07 Jun 2010"

'==========================================================================
Public Function air_check_values() As String

Dim txt As String, CRLF As String, TB As String

CRLF = Chr(13) + Chr(10)
TB = Chr(9)

If Molar_mass_air_L2000 = Molar_mass_air_si Then

  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  'RESULTS CORRESPONDING TO VERSION 1.1 (V. 1.1)
  'NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  'MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  'THE PORTION OF THE CODE BELOW (FROM HERE TO ELSEIF) USES THIS VALUE OF THE MOLAR MASS.
  'TO USES THE ORIGINAL VALUE USED BY LEMMON ET AL. (2000) YOU MUST EDIT CONSTANTS_0 TO
  'CORRESPOND TO VERSION 1.0 (v. 1.0).
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = "COMPARISON OF CHECK VALUES FOR PROPERTIES OF DRY AND MOIST AIR, SIA VERSION 1.1" + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM CONVERT" + CRLF + CRLF
  
  txt = txt + "air_molar_mass_si(0.5)       =" + TwoCols(air_molar_mass_si(0.5), 2.22142374908826E-02) + CRLF
  txt = txt + "air_molfraction_air_si(0.5)  =" + TwoCols(air_molfraction_air_si(0.5), 0.383460809717551) + CRLF
  txt = txt + "air_molfraction_vap_si(0.5)  =" + TwoCols(air_molfraction_vap_si(0.5), 0.616539190282449) + CRLF
  txt = txt + "air_massfraction_air_si(0.5) =" + TwoCols(air_massfraction_air_si(0.5), 0.616539190282449) + CRLF
  txt = txt + "air_massfraction_vap_si(0.5) =" + TwoCols(air_massfraction_vap_si(0.5), 0.383460809717551) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_1" + CRLF + CRLF
  
  txt = txt + "dry_f_si(0,0,300,0.001) =" + TwoCols(dry_f_si(0, 0, 300, 0.001), -696239.965189878) + CRLF
  txt = txt + "dry_f_si(1,0,300,0.001) =" + TwoCols(dry_f_si(1, 0, 300, 0.001), -2124.55145455549) + CRLF
  txt = txt + "dry_f_si(0,1,300,0.001) =" + TwoCols(dry_f_si(0, 1, 300, 0.001), 86114714.9595876) + CRLF
  txt = txt + "dry_f_si(2,0,300,0.001) =" + TwoCols(dry_f_si(2, 0, 300, 0.001), -2.39242390805757) + CRLF
  txt = txt + "dry_f_si(1,1,300,0.001) =" + TwoCols(dry_f_si(1, 1, 300, 0.001), 287049.624545385) + CRLF
  txt = txt + "dry_f_si(0,2,300,0.001) =" + TwoCols(dry_f_si(0, 2, 300, 0.001), -86114738036.0821) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_2" + CRLF + CRLF
  
  txt = txt + "air_f_mix_si(0,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 0, 0.9, 300, 1), -25.8379179181588) + CRLF
  txt = txt + "air_f_mix_si(1,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 0, 0, 0.9, 300, 1), 233.827370433721) + CRLF
  txt = txt + "air_f_mix_si(0,1,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 1, 0, 0.9, 300, 1), 0.1641959520604) + CRLF
  txt = txt + "air_f_mix_si(0,0,1,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 1, 0.9, 300, 1), -26.2357498619055) + CRLF
  txt = txt + "air_f_mix_si(2,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(2, 0, 0, 0.9, 300, 1), 500.273928155059) + CRLF
  txt = txt + "air_f_mix_si(1,1,0,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 1, 0, 0.9, 300, 1), -1.53932744055467) + CRLF
  txt = txt + "air_f_mix_si(1,0,1,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 0, 1, 0.9, 300, 1), 241.520643317113) + CRLF
  txt = txt + "air_f_mix_si(0,2,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 2, 0, 0.9, 300, 1), -6.87329742958611E-04) + CRLF
  txt = txt + "air_f_mix_si(0,1,1,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 1, 1, 0.9, 300, 1), 0.172192606102968) + CRLF
  txt = txt + "air_f_mix_si(0,0,2,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 2, 0.9, 300, 1), -0.795663887493488) + CRLF
  txt = txt + CRLF
  txt = txt + "air_f_si(0,0,0,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 0, 0.9, 300, 1), -95019.594323089) + CRLF
  txt = txt + "air_f_si(1,0,0,0.9,300,1) =" + TwoCols(air_f_si(1, 0, 0, 0.9, 300, 1), -205645.554994923) + CRLF
  txt = txt + "air_f_si(0,1,0,0.9,300,1) =" + TwoCols(air_f_si(0, 1, 0, 0.9, 300, 1), -940.175394022848) + CRLF
  txt = txt + "air_f_si(0,0,1,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 1, 0.9, 300, 1), 91175.3848661597) + CRLF
  txt = txt + "air_f_si(2,0,0,0.9,300,1) =" + TwoCols(air_f_si(2, 0, 0, 0.9, 300, 1), 1447768.46379203) + CRLF
  txt = txt + "air_f_si(1,1,0,0.9,300,1) =" + TwoCols(air_f_si(1, 1, 0, 0.9, 300, 1), 7443.09771949878) + CRLF
  txt = txt + "air_f_si(1,0,1,0.9,300,1) =" + TwoCols(air_f_si(1, 0, 1, 0.9, 300, 1), -48847.909682604) + CRLF
  txt = txt + "air_f_si(0,2,0,0.9,300,1) =" + TwoCols(air_f_si(0, 2, 0, 0.9, 300, 1), -2.96482218054432) + CRLF
  txt = txt + "air_f_si(0,1,1,0.9,300,1) =" + TwoCols(air_f_si(0, 1, 1, 0.9, 300, 1), 312.063110700377) + CRLF
  txt = txt + "air_f_si(0,0,2,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 2, 0.9, 300, 1), -91421.4440689192) + CRLF
  txt = txt + CRLF
  txt = txt + "air_f_cp_si(0.9,300,1)              =" + TwoCols(air_f_cp_si(0.9, 300, 1), 1210.7403105811) + CRLF
  txt = txt + "air_f_cv_si(0.9,300,1)              =" + TwoCols(air_f_cv_si(0.9, 300, 1), 889.446654163297) + CRLF
  txt = txt + "air_f_enthalpy_si(0.9,300,1)        =" + TwoCols(air_f_enthalpy_si(0.9, 300, 1), 278208.408749925) + CRLF
  txt = txt + "air_f_entropy_si(0.9,300,1)         =" + TwoCols(air_f_entropy_si(0.9, 300, 1), 940.175394022848) + CRLF
  txt = txt + "air_f_expansion_si(0.9,300,1)       =" + TwoCols(air_f_expansion_si(0.9, 300, 1), 3.4319303307666E-03) + CRLF
  txt = txt + "air_f_gibbs_energy_si(0.9,300,1)    =" + TwoCols(air_f_gibbs_energy_si(0.9, 300, 1), -3844.20945692934) + CRLF
  txt = txt + "air_f_internal_energy_si(0.9,300,1) =" + TwoCols(air_f_internal_energy_si(0.9, 300, 1), 187033.023883765) + CRLF
  txt = txt + "air_f_kappa_s_si(0.9,300,1)         =" + TwoCols(air_f_kappa_s_si(0.9, 300, 1), 8.0791362681566E-06) + CRLF
  txt = txt + "air_f_kappa_t_si(0.9,300,1)         =" + TwoCols(air_f_kappa_t_si(0.9, 300, 1), 1.0997552139579E-05) + CRLF
  txt = txt + "air_f_lapserate_si(0.9,300,1)       =" + TwoCols(air_f_lapserate_si(0.9, 300, 1), 8.50371537341341E-04) + CRLF
  txt = txt + "air_f_pressure_si(0.9,300,1)        =" + TwoCols(air_f_pressure_si(0.9, 300, 1), 91175.3848661597) + CRLF
  txt = txt + "air_f_soundspeed_si(0.9,300,1)      =" + TwoCols(air_f_soundspeed_si(0.9, 300, 1), 351.817577078371) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3A" + CRLF + CRLF
  
  txt = txt + "air_g_si(0, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 0, 0.9, 300, 100000), 4577.93065688699) + CRLF
  txt = txt + "air_g_si(1, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 0, 0, 0.9, 300, 100000), -210141.953243099) + CRLF
  txt = txt + "air_g_si(0, 1, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 1, 0, 0.9, 300, 100000), -911.170080461387) + CRLF
  txt = txt + "air_g_si(0, 0, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 1, 0.9, 300, 100000), 0.911504137472816) + CRLF
  txt = txt + "air_g_si(2, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(2, 0, 0, 0.9, 300, 100000), 1415779.23409976) + CRLF
  txt = txt + "air_g_si(1, 1, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 1, 0, 0.9, 300, 100000), 7566.34779196021) + CRLF
  txt = txt + "air_g_si(1, 0, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 0, 1, 0.9, 300, 100000), -0.483353002175824) + CRLF
  txt = txt + "air_g_si(0, 2, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 2, 0, 0.9, 300, 100000), -4.15449972147975) + CRLF
  txt = txt + "air_g_si(0, 1, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 1, 1, 0.9, 300, 100000), 3.15111222847295E-03) + CRLF
  txt = txt + "air_g_si(0, 0, 2, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 2, 0.9, 300, 100000), -9.14462130186205E-06) + CRLF
  txt = txt + "air_density_si(0.9, 300, 1E5)    =" + TwoCols(air_density_si(0.9, 300, 100000), 1.09708772444253) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3B" + CRLF + CRLF
  
  txt = txt + "air_g_chempot_vap_si(0.9, 300, 1E5)           =" + TwoCols(air_g_chempot_vap_si(0.9, 300, 100000), 193705.688575676) + CRLF
  txt = txt + "air_g_contraction_si(0.9, 300, 1E5)           =" + TwoCols(air_g_contraction_si(0.9, 300, 100000), 0.530280645259538) + CRLF
  txt = txt + "air_g_compressibilityfactor_si(0.9, 300, 1E5) =" + TwoCols(air_g_compressibilityfactor_si(0.9, 300, 100000), 0.997825670991282) + CRLF
  txt = txt + "air_g_cp_si(0.9, 300, 1E5)                    =" + TwoCols(air_g_cp_si(0.9, 300, 100000), 1246.34991644392) + CRLF
  txt = txt + "air_g_cv_si(0.9, 300, 1E5)                    =" + TwoCols(air_g_cv_si(0.9, 300, 100000), 920.60078101248) + CRLF
  txt = txt + "air_g_enthalpy_si(0.9, 300, 1E5)              =" + TwoCols(air_g_enthalpy_si(0.9, 300, 100000), 277928.954795303) + CRLF
  txt = txt + "air_g_entropy_si(0.9, 300, 1E5)               =" + TwoCols(air_g_entropy_si(0.9, 300, 100000), 911.170080461387) + CRLF
  txt = txt + "air_g_expansion_si(0.9, 300, 1E5)             =" + TwoCols(air_g_expansion_si(0.9, 300, 100000), 3.45704654419841E-03) + CRLF
  txt = txt + "air_g_density_si(0.9, 300, 1E5)               =" + TwoCols(air_g_density_si(0.9, 300, 100000), 1.09708772444253) + CRLF
  txt = txt + "air_g_gibbs_energy_si(0.9, 300, 1E5)          =" + TwoCols(air_g_gibbs_energy_si(0.9, 300, 100000), 4577.93065688699) + CRLF
  txt = txt + "air_g_internal_energy_si(0.9, 300, 1E5)       =" + TwoCols(air_g_internal_energy_si(0.9, 300, 100000), 186778.541048021) + CRLF
  txt = txt + "air_g_kappa_s_si(0.9, 300, 1E5)               =" + TwoCols(air_g_kappa_s_si(0.9, 300, 100000), 7.4103450544927E-06) + CRLF
  txt = txt + "air_g_kappa_t_si(0.9, 300, 1E5)               =" + TwoCols(air_g_kappa_t_si(0.9, 300, 100000), 1.00324517749485E-05) + CRLF
  txt = txt + "air_g_lapserate_si(0.9, 300, 1E5)             =" + TwoCols(air_g_lapserate_si(0.9, 300, 100000), 7.58481752250688E-04) + CRLF
  txt = txt + "air_g_soundspeed_si(0.9, 300, 1E5)            =" + TwoCols(air_g_soundspeed_si(0.9, 300, 100000), 350.719656182404) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3C" + CRLF + CRLF
  
  txt = txt + "air_h_si(0, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 0, 0.9, 900, 100000), 274592.611782659) + CRLF
  txt = txt + "air_h_si(1, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 0, 0, 0.9, 900, 100000), -229706.905765403) + CRLF
  txt = txt + "air_h_si(0, 1, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 1, 0, 0.9, 900, 100000), 297.403043058409) + CRLF
  txt = txt + "air_h_si(0, 0, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 1, 0.9, 900, 100000), 0.903262695635698) + CRLF
  txt = txt + "air_h_si(2, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(2, 0, 0, 0.9, 900, 100000), 13963273.0103549) + CRLF
  txt = txt + "air_h_si(1, 1, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 1, 0, 0.9, 900, 100000), 1676.8509855168) + CRLF
  txt = txt + "air_h_si(1, 0, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 0, 1, 0.9, 900, 100000), -0.467537679038088) + CRLF
  txt = txt + "air_h_si(0, 2, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 2, 0, 0.9, 900, 100000), 0.223684689765269) + CRLF
  txt = txt + "air_h_si(0, 1, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 1, 1, 0.9, 900, 100000), 7.15703143992457E-04) + CRLF
  txt = txt + "air_h_si(0, 0, 2, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 2, 0.9, 900, 100000), -6.78105152859357E-06) + CRLF
  txt = txt + CRLF
  txt = txt + "air_pottemp_si(0.9, 300, 5d4, 1E5)     =" + TwoCols(air_pottemp_si(0.9, 300, 50000, 100000), 363.653905688047) + CRLF
  txt = txt + "air_potdensity_si(0.9, 300, 5d4, 1E5)  =" + TwoCols(air_potdensity_si(0.9, 300, 50000, 100000), 0.903509489711487) + CRLF
  txt = txt + "air_potenthalpy_si(0.9, 300, 5d4, 1E5) =" + TwoCols(air_potenthalpy_si(0.9, 300, 50000, 100000), 348872.568665216) + CRLF
  txt = txt + "air_temperature_si(0.9, 900, 1E5)      =" + TwoCols(air_temperature_si(0.9, 900, 100000), 297.403043058409) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_5" + CRLF + CRLF
  
  txt = txt + "air_lapserate_moist_c100m(50, 20, 1000) =" + TwoCols(air_lapserate_moist_c100m(50, 20, 1000), 0.971588085046374) + CRLF

Else

'SIA Version 1.0:

  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  'RESULTS CORRESPONDING TO VERSION 1.0 (V. 1.0)
  'NOTE THAT LEMMON AND COLLEAGUES HAVE DECIDED THAT IT IS PREFERABLE TO USE THE LATEST
  'MOLAR MASS WITH THEIR MOLAR FORMULATION GIVEN IN LEMMON ET AL. (2000).
  'THE PORTION OF THE CODE BELOW (FROM HERE TO ENDIF) WILL ONLY BE ACTIVATED IF
  'YOU CHANGE TO VERSION 1.0 (V. 1.0) IN CONSTANTS_0
  '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  txt = "COMPARISON OF CHECK VALUES FOR PROPERTIES OF DRY AND MOIST AIR, SIA VERSION 1.0" + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM CONVERT" + CRLF + CRLF
  
  txt = txt + "air_molar_mass_si(0.5)       =" + TwoCols(air_molar_mass_si(0.5), 2.22122197773792E-02) + CRLF
  txt = txt + "air_molfraction_air_si(0.5)  =" + TwoCols(air_molfraction_air_si(0.5), 0.383516809814342) + CRLF
  txt = txt + "air_molfraction_vap_si(0.5)  =" + TwoCols(air_molfraction_vap_si(0.5), 0.616483190185658) + CRLF
  txt = txt + "air_massfraction_air_si(0.5) =" + TwoCols(air_massfraction_air_si(0.5), 0.616483190185658) + CRLF
  txt = txt + "air_massfraction_vap_si(0.5) =" + TwoCols(air_massfraction_vap_si(0.5), 0.383516809814342) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_1" + CRLF + CRLF
  
  txt = txt + "dry_f_si(0,0,300,0.001) =" + TwoCols(dry_f_si(0, 0, 300, 0.001), -696384.49528633) + CRLF
  txt = txt + "dry_f_si(1,0,300,0.001) =" + TwoCols(dry_f_si(1, 0, 300, 0.001), -2124.98673213572) + CRLF
  txt = txt + "dry_f_si(0,1,300,0.001) =" + TwoCols(dry_f_si(0, 1, 300, 0.001), 86135114.6607569) + CRLF
  txt = txt + "dry_f_si(2,0,300,0.001) =" + TwoCols(dry_f_si(2, 0, 300, 0.001), -2.39299064929384) + CRLF
  txt = txt + "dry_f_si(1,1,300,0.001) =" + TwoCols(dry_f_si(1, 1, 300, 0.001), 287117.623821587) + CRLF
  txt = txt + "dry_f_si(0,2,300,0.001) =" + TwoCols(dry_f_si(0, 2, 300, 0.001), -86135137748.1857) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_2" + CRLF + CRLF
  
  txt = txt + "air_f_mix_si(0,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 0, 0.9, 300, 1), -25.8379179181588) + CRLF
  txt = txt + "air_f_mix_si(1,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 0, 0, 0.9, 300, 1), 233.827370433721) + CRLF
  txt = txt + "air_f_mix_si(0,1,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 1, 0, 0.9, 300, 1), 0.1641959520604) + CRLF
  txt = txt + "air_f_mix_si(0,0,1,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 1, 0.9, 300, 1), -26.2357498619055) + CRLF
  txt = txt + "air_f_mix_si(2,0,0,0.9,300,1) =" + TwoCols(air_f_mix_si(2, 0, 0, 0.9, 300, 1), 500.273928155059) + CRLF
  txt = txt + "air_f_mix_si(1,1,0,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 1, 0, 0.9, 300, 1), -1.53932744055467) + CRLF
  txt = txt + "air_f_mix_si(1,0,1,0.9,300,1) =" + TwoCols(air_f_mix_si(1, 0, 1, 0.9, 300, 1), 241.520643317113) + CRLF
  txt = txt + "air_f_mix_si(0,2,0,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 2, 0, 0.9, 300, 1), -6.87329742958611E-04) + CRLF
  txt = txt + "air_f_mix_si(0,1,1,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 1, 1, 0.9, 300, 1), 0.172192606102968) + CRLF
  txt = txt + "air_f_mix_si(0,0,2,0.9,300,1) =" + TwoCols(air_f_mix_si(0, 0, 2, 0.9, 300, 1), -0.795663887493488) + CRLF
  txt = txt + CRLF
  txt = txt + "air_f_si(0,0,0,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 0, 0.9, 300, 1), -95024.7900037553) + CRLF
  txt = txt + "air_f_si(1,0,0,0.9,300,1) =" + TwoCols(air_f_si(1, 0, 0, 0.9, 300, 1), -205630.937995868) + CRLF
  txt = txt + "air_f_si(0,1,0,0.9,300,1) =" + TwoCols(air_f_si(0, 1, 0, 0.9, 300, 1), -940.150652240964) + CRLF
  txt = txt + "air_f_si(0,0,1,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 1, 0.9, 300, 1), 91193.7358459761) + CRLF
  txt = txt + "air_f_si(2,0,0,0.9,300,1) =" + TwoCols(air_f_si(2, 0, 0, 0.9, 300, 1), 1447791.10862457) + CRLF
  txt = txt + "air_f_si(1,1,0,0.9,300,1) =" + TwoCols(air_f_si(1, 1, 0, 0.9, 300, 1), 7443.19342187571) + CRLF
  txt = txt + "air_f_si(1,0,1,0.9,300,1) =" + TwoCols(air_f_si(1, 0, 1, 0.9, 300, 1), -48827.5293333158) + CRLF
  txt = txt + "air_f_si(0,2,0,0.9,300,1) =" + TwoCols(air_f_si(0, 2, 0, 0.9, 300, 1), -2.96533251320995) + CRLF
  txt = txt + "air_f_si(0,1,1,0.9,300,1) =" + TwoCols(air_f_si(0, 1, 1, 0.9, 300, 1), 312.124501057728) + CRLF
  txt = txt + "air_f_si(0,0,2,0.9,300,1) =" + TwoCols(air_f_si(0, 0, 2, 0.9, 300, 1), -91439.8037141926) + CRLF
  txt = txt + CRLF
  txt = txt + "air_f_cp_si(0.9,300,1)              =" + TwoCols(air_f_cp_si(0.9, 300, 1), 1210.95501131063) + CRLF
  txt = txt + "air_f_cv_si(0.9,300,1)              =" + TwoCols(air_f_cv_si(0.9, 300, 1), 889.599753962985) + CRLF
  txt = txt + "air_f_enthalpy_si(0.9,300,1)        =" + TwoCols(air_f_enthalpy_si(0.9, 300, 1), 278214.14151451) + CRLF
  txt = txt + "air_f_entropy_si(0.9,300,1)         =" + TwoCols(air_f_entropy_si(0.9, 300, 1), 940.150652240964) + CRLF
  txt = txt + "air_f_expansion_si(0.9,300,1)       =" + TwoCols(air_f_expansion_si(0.9, 300, 1), 3.43191318697755E-03) + CRLF
  txt = txt + "air_f_gibbs_energy_si(0.9,300,1)    =" + TwoCols(air_f_gibbs_energy_si(0.9, 300, 1), -3831.0541577792) + CRLF
  txt = txt + "air_f_internal_energy_si(0.9,300,1) =" + TwoCols(air_f_internal_energy_si(0.9, 300, 1), 187020.405668534) + CRLF
  txt = txt + "air_f_kappa_s_si(0.9,300,1)         =" + TwoCols(air_f_kappa_s_si(0.9, 300, 1), 8.07746486644041E-06) + CRLF
  txt = txt + "air_f_kappa_t_si(0.9,300,1)         =" + TwoCols(air_f_kappa_t_si(0.9, 300, 1), 1.09953341546321E-05) + CRLF
  txt = txt + "air_f_lapserate_si(0.9,300,1)       =" + TwoCols(air_f_lapserate_si(0.9, 300, 1), 8.50216520413048E-04) + CRLF
  txt = txt + "air_f_pressure_si(0.9,300,1)        =" + TwoCols(air_f_pressure_si(0.9, 300, 1), 91193.7358459761) + CRLF
  txt = txt + "air_f_soundspeed_si(0.9,300,1)      =" + TwoCols(air_f_soundspeed_si(0.9, 300, 1), 351.853974518412) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3A" + CRLF + CRLF
  
  txt = txt + "air_g_si(0, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 0, 0.9, 300, 100000), 4574.43347101731) + CRLF
  txt = txt + "air_g_si(1, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 0, 0, 0.9, 300, 100000), -210115.722120426) + CRLF
  txt = txt + "air_g_si(0, 1, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 1, 0, 0.9, 300, 100000), -911.203092171182) + CRLF
  txt = txt + "air_g_si(0, 0, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 1, 0.9, 300, 100000), 0.911688234199384) + CRLF
  txt = txt + "air_g_si(2, 0, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(2, 0, 0, 0.9, 300, 100000), 1415842.71443159) + CRLF
  txt = txt + "air_g_si(1, 1, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 1, 0, 0.9, 300, 100000), 7566.48354961423) + CRLF
  txt = txt + "air_g_si(1, 0, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(1, 0, 1, 0.9, 300, 100000), -0.483164035113658) + CRLF
  txt = txt + "air_g_si(0, 2, 0, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 2, 0, 0.9, 300, 100000), -4.15491953968641) + CRLF
  txt = txt + "air_g_si(0, 1, 1, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 1, 1, 0.9, 300, 100000), 3.15167187428014E-03) + CRLF
  txt = txt + "air_g_si(0, 0, 2, 0.9, 300, 1E5) =" + TwoCols(air_g_si(0, 0, 2, 0.9, 300, 100000), -9.14645118670962E-06) + CRLF
  txt = txt + "air_density_si(0.9, 300, 1E5)    =" + TwoCols(air_density_si(0.9, 300, 100000), 1.09686619009421) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3B" + CRLF + CRLF
  
  txt = txt + "air_g_chempot_vap_si(0.9, 300, 1E5)           =" + TwoCols(air_g_chempot_vap_si(0.9, 300, 100000), 193678.583379401) + CRLF
  txt = txt + "air_g_contraction_si(0.9, 300, 1E5)           =" + TwoCols(air_g_contraction_si(0.9, 300, 100000), 0.529966294385666) + CRLF
  txt = txt + "air_g_compressibilityfactor_si(0.9, 300, 1E5) =" + TwoCols(air_g_compressibilityfactor_si(0.9, 300, 100000), 0.99782665440423) + CRLF
  txt = txt + "air_g_cp_si(0.9, 300, 1E5)                    =" + TwoCols(air_g_cp_si(0.9, 300, 100000), 1246.47586190592) + CRLF
  txt = txt + "air_g_cv_si(0.9, 300, 1E5)                    =" + TwoCols(air_g_cv_si(0.9, 300, 100000), 920.676202550767) + CRLF
  txt = txt + "air_g_enthalpy_si(0.9, 300, 1E5)              =" + TwoCols(air_g_enthalpy_si(0.9, 300, 100000), 277935.361122372) + CRLF
  txt = txt + "air_g_entropy_si(0.9, 300, 1E5)               =" + TwoCols(air_g_entropy_si(0.9, 300, 100000), 911.203092171182) + CRLF
  txt = txt + "air_g_expansion_si(0.9, 300, 1E5)             =" + TwoCols(air_g_expansion_si(0.9, 300, 100000), 3.45696232116875E-03) + CRLF
  txt = txt + "air_g_density_si(0.9, 300, 1E5)               =" + TwoCols(air_g_density_si(0.9, 300, 100000), 1.09686619009421) + CRLF
  txt = txt + "air_g_gibbs_energy_si(0.9, 300, 1E5)          =" + TwoCols(air_g_gibbs_energy_si(0.9, 300, 100000), 4574.43347101731) + CRLF
  txt = txt + "air_g_internal_energy_si(0.9, 300, 1E5)       =" + TwoCols(air_g_internal_energy_si(0.9, 300, 100000), 186766.537702434) + CRLF
  txt = txt + "air_g_kappa_s_si(0.9, 300, 1E5)               =" + TwoCols(air_g_kappa_s_si(0.9, 300, 100000), 7.41018952703296E-06) + CRLF
  txt = txt + "air_g_kappa_t_si(0.9, 300, 1E5)               =" + TwoCols(air_g_kappa_t_si(0.9, 300, 100000), 1.00324330660489E-05) + CRLF
  txt = txt + "air_g_lapserate_si(0.9, 300, 1E5)             =" + TwoCols(air_g_lapserate_si(0.9, 300, 100000), 7.58539809056811E-04) + CRLF
  txt = txt + "air_g_soundspeed_si(0.9, 300, 1E5)            =" + TwoCols(air_g_soundspeed_si(0.9, 300, 100000), 350.758752725391) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_3C" + CRLF + CRLF
  
  txt = txt + "air_h_si(0, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 0, 0.9, 900, 100000), 274589.199191971) + CRLF
  txt = txt + "air_h_si(1, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 0, 0, 0.9, 900, 100000), -229734.926516548) + CRLF
  txt = txt + "air_h_si(0, 1, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 1, 0, 0.9, 900, 100000), 297.395859294205) + CRLF
  txt = txt + "air_h_si(0, 0, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 1, 0.9, 900, 100000), 0.903422384671727) + CRLF
  txt = txt + "air_h_si(2, 0, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(2, 0, 0, 0.9, 900, 100000), 13959323.1015864) + CRLF
  txt = txt + "air_h_si(1, 1, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 1, 0, 0.9, 900, 100000), 1676.3382283477) + CRLF
  txt = txt + "air_h_si(1, 0, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(1, 0, 1, 0.9, 900, 100000), -0.467305898316057) + CRLF
  txt = txt + "air_h_si(0, 2, 0, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 2, 0, 0.9, 900, 100000), 0.223618143111274) + CRLF
  txt = txt + "air_h_si(0, 1, 1, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 1, 1, 0.9, 900, 100000), 7.15646251374936E-04) + CRLF
  txt = txt + "air_h_si(0, 0, 2, 0.9, 900, 1E5) =" + TwoCols(air_h_si(0, 0, 2, 0.9, 900, 100000), -6.78234488399621E-06) + CRLF
  txt = txt + CRLF
  txt = txt + "air_pottemp_si(0.9, 300, 5d4, 1E5)     =" + TwoCols(air_pottemp_si(0.9, 300, 50000, 100000), 363.65437317883) + CRLF
  txt = txt + "air_potdensity_si(0.9, 300, 5d4, 1E5)  =" + TwoCols(air_potdensity_si(0.9, 300, 50000, 100000), 0.903326577187662) + CRLF
  txt = txt + "air_potenthalpy_si(0.9, 300, 5d4, 1E5) =" + TwoCols(air_potenthalpy_si(0.9, 300, 50000, 100000), 348892.581996519) + CRLF
  txt = txt + "air_temperature_si(0.9, 900, 1E5)      =" + TwoCols(air_temperature_si(0.9, 900, 100000), 297.395859294205) + CRLF
  txt = txt + CRLF + CRLF
  
  txt = txt + "COMPARISON OF CHECK VALUES FROM AIR_5" + CRLF + CRLF
  
  txt = txt + "air_lapserate_moist_c100m(50, 20, 1000) =" + TwoCols(air_lapserate_moist_c100m(50, 20, 1000), 0.971359680720479) + CRLF

End If

air_check_values = txt

End Function


