VERSION 5.00
Begin VB.Form TEOS10_SIA_Form 
   AutoRedraw      =   -1  'True
   Caption         =   "TEOS-10: SIA Library Functions Version 3.0"
   ClientHeight    =   6405
   ClientLeft      =   165
   ClientTop       =   780
   ClientWidth     =   8685
   ForeColor       =   &H00000000&
   Icon            =   "TEOS10_SIA.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6405
   ScaleWidth      =   8685
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Label Title_lbl 
      Alignment       =   2  'Zentriert
      BackStyle       =   0  'Transparent
      Caption         =   "Thermodynamic Properties of Water, Vapour, Ice, Seawater, and Humid Air"
      BeginProperty Font 
         Name            =   "Times New Roman"
         Size            =   10.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   372
      Index           =   1
      Left            =   360
      TabIndex        =   1
      Top             =   360
      Width           =   8292
   End
   Begin VB.Label Title_lbl 
      Alignment       =   2  'Zentriert
      BackStyle       =   0  'Transparent
      Caption         =   "Antarctic Peninsula, December 2002"
      BeginProperty Font 
         Name            =   "Times New Roman"
         Size            =   10.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   372
      Index           =   0
      Left            =   360
      TabIndex        =   0
      Top             =   6000
      Width           =   8292
   End
   Begin VB.Image Iceberg_Img 
      Height          =   14400
      Left            =   240
      Picture         =   "TEOS10_SIA.frx":038A
      Stretch         =   -1  'True
      Top             =   240
      Width           =   19200
   End
   Begin VB.Menu Menu_File 
      Caption         =   "&File"
      Begin VB.Menu File_SaveCheckTables 
         Caption         =   "Save Check &Tables"
      End
      Begin VB.Menu File_SaveCheckValues 
         Caption         =   "Save Check &Values"
      End
      Begin VB.Menu File_SaveExamples 
         Caption         =   "Save &Examples"
      End
      Begin VB.Menu File_line1 
         Caption         =   "-"
      End
      Begin VB.Menu File_Exit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu Menu_Check 
      Caption         =   "&Check"
      Begin VB.Menu Check_IAPWS95 
         Caption         =   "IAPWS-9&5"
         Begin VB.Menu IAPWS95_Check 
            Caption         =   "Check Table 6"
            Index           =   0
         End
         Begin VB.Menu IAPWS95_Check 
            Caption         =   "Check Table 7"
            Index           =   1
         End
         Begin VB.Menu IAPWS95_Check 
            Caption         =   "Check Table 8"
            Index           =   2
         End
      End
      Begin VB.Menu Check_IAPWS06 
         Caption         =   "IAPWS-0&6"
         Begin VB.Menu IAPWS06_Check 
            Caption         =   "Check Table 6"
            Index           =   0
         End
      End
      Begin VB.Menu Check_IAPWS08 
         Caption         =   "IAPWS-0&8"
         Begin VB.Menu IAPWS08_Check 
            Caption         =   "Check Table 8a"
            Index           =   0
         End
         Begin VB.Menu IAPWS08_Check 
            Caption         =   "Check Table 8b"
            Index           =   1
         End
         Begin VB.Menu IAPWS08_Check 
            Caption         =   "Check Table 8c"
            Index           =   2
         End
      End
      Begin VB.Menu Check_IAPWS09 
         Caption         =   "IAPWS-0&9"
         Begin VB.Menu IAPWS09_Check 
            Caption         =   "Check Table 6"
            Index           =   0
         End
      End
      Begin VB.Menu Check_IAPWS10 
         Caption         =   "IAPWS-&10"
         Begin VB.Menu IAPWS10_Check 
            Caption         =   "Check Table 13"
            Index           =   0
         End
         Begin VB.Menu IAPWS10_Check 
            Caption         =   "Check Table 14"
            Index           =   1
         End
         Begin VB.Menu IAPWS10_Check 
            Caption         =   "Check Table 15"
            Index           =   2
         End
      End
      Begin VB.Menu Check_line1 
         Caption         =   "-"
      End
      Begin VB.Menu Check_Quad 
         Caption         =   "&Feistel et al. (2008)"
         Begin VB.Menu Quad_Table2 
            Caption         =   "Table 2"
         End
         Begin VB.Menu Quad_Table3 
            Caption         =   "Table 3"
         End
         Begin VB.Menu Quad_TableA1 
            Caption         =   "Table A1"
         End
         Begin VB.Menu Quad_TableA2 
            Caption         =   "Table A2"
         End
         Begin VB.Menu Quad_TableA3 
            Caption         =   "Table A3"
         End
         Begin VB.Menu Quad_TableA4 
            Caption         =   "Table A4"
         End
         Begin VB.Menu Quad_TableA5 
            Caption         =   "Table A5"
         End
         Begin VB.Menu Quad_TableA6 
            Caption         =   "Table A6"
         End
         Begin VB.Menu Quad_TableA7 
            Caption         =   "Table A7"
         End
         Begin VB.Menu Quad_TableA8 
            Caption         =   "Table A8"
         End
      End
      Begin VB.Menu Check_Lemmon2000 
         Caption         =   "&Lemmon et al. (2000)"
         Begin VB.Menu Check_Lemmon 
            Caption         =   "Helmholtz Function"
            Index           =   0
         End
         Begin VB.Menu Check_Lemmon 
            Caption         =   "Gibbs Function"
            Index           =   1
         End
      End
      Begin VB.Menu Check_IAPWS_IF97 
         Caption         =   "IAPWS-IF9&7"
         Begin VB.Menu IAPWS97_Check 
            Caption         =   "Table_5"
            Index           =   0
         End
         Begin VB.Menu IAPWS97_Check 
            Caption         =   "Table 15"
            Index           =   1
         End
      End
   End
   Begin VB.Menu Menu_Examples 
      Caption         =   "&Examples"
      Begin VB.Menu Examples_FluidWaterProperties 
         Caption         =   "Fluid &Water Properties"
      End
      Begin VB.Menu Examples_IceIhProperties 
         Caption         =   "&Ice Ih Properties"
      End
      Begin VB.Menu Examples_SeawaterProperties 
         Caption         =   "&Seawater Properties"
      End
      Begin VB.Menu Examples_AirProperties 
         Caption         =   "&Air Properties"
      End
   End
   Begin VB.Menu Menu_Info 
      Caption         =   "&Info"
   End
End
Attribute VB_Name = "TEOS10_SIA_Form"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const Version = "02 Feb 2012"
Private Function InfoText() As String

Dim txt As String
Dim CRLF As String
CRLF = Chr(13) + Chr(10)

txt = "Source code library SIA (Seawater-Ice-Air) of TEOS-10 for" + CRLF
txt = txt + "thermodynamic properties of liquid water, water vapour, ice, seawater and humid air." + CRLF
txt = txt + "Version 3.0 (" + Version + ")" + CRLF + CRLF

txt = txt + "Developed by the SCOR/IAPSO Working Group 127" + CRLF
txt = txt + "On Thermodynamics and Equation of State of Seawater" + CRLF
txt = txt + "in cooperation with the partners listed below," + CRLF
txt = txt + "based on documents released in 2006, 2008, 2009 and 2010 by the" + CRLF
txt = txt + "International Association for the Properties of Water and Steam (www.iapws.org)." + CRLF + CRLF

txt = txt + "Implementation of the TEOS-10 SIA Library in VB6 by Rainer Feistel, 2008 - 2011" + CRLF
txt = txt + "for publication in Ocean Science, as" + CRLF + CRLF

txt = txt + "Feistel, R., Wright, D.G., Jackett, D.R., Miyagawa, K., Reissmann, J.H., Wagner, W.," + CRLF
txt = txt + "Overhoff, U., Guder, C., Feistel, A. and Marion, G.M.:" + CRLF
txt = txt + "Numerical implementation and oceanographic application of the thermodynamic" + CRLF
txt = txt + "potentials of water, vapour, ice, seawater and air." + CRLF
txt = txt + "Part I: Background and Equations. Ocean Science 6, 633677, 2010" + CRLF
txt = txt + "Available at www.ocean-sci.net/6/633/2010/" + CRLF + CRLF

txt = txt + "Wright, D.G., Feistel, R., Reissmann, J.H., Miyagawa, K., Jackett, D.R., Wagner, W.," + CRLF
txt = txt + "Overhoff, U., Guder, C., Feistel, A. and Marion, G.M.:" + CRLF
txt = txt + "Numerical implementation and oceanographic application of the thermodynamic" + CRLF
txt = txt + "potentials of water, vapour, ice, seawater and air." + CRLF
txt = txt + "Part II: The Library Routines, Ocean Science 6, 695-718, 2010" + CRLF
txt = txt + "Available at www.ocean-sci.net/6/695/2010/" + CRLF + CRLF

txt = txt + "Feistel, R., Wright, D.G., Kretzschmar,H.-J., Hagen, E., Herrmann, S. and Span, R.:" + CRLF
txt = txt + "Thermodynamic Properties of Sea Air." + CRLF
txt = txt + "Ocean Science 6, 91-141, 2010" + CRLF
txt = txt + "Available at http://www.ocean-sci.net/6/91/2010/" + CRLF + CRLF

txt = txt + "SIA Library code updates are available from www.teos-10.org"

InfoText = txt

End Function

Private Sub TextWindow()

Iceberg_Img.Visible = False
Title_lbl(0).Visible = False
Title_lbl(1).Visible = False

BackColor = QBColor(15)
ForeColor = QBColor(0)
Me.FontName = "Courier"
Cls

End Sub

Private Sub Examples_SeawaterProperties_Click()

Dim sa As Double, t As Double, p As Double

TextWindow

'computation example: set any values of SA, T and P you like

sa = 0.03516504        'Standard-Ocean reference salinity
p = 101325             'Standard-Ocean surface pressure
t = 273.15             'Standard-Ocean temperature

Me.Print Sea_3a_example_call(sa, t, p)

End Sub

Private Sub File_SaveCheckTables_Click()

Dim path$, h%, limits%

path = App.path
If Right(path, 1) <> "\" Then path = path + "\"
h% = FreeFile
Open path + "SIA_CheckTables.txt" For Output As #h

Me.MousePointer = vbHourglass

Print #h, chk_IAPWS95_Table6
Print #h, chk_IAPWS95_Table7
Print #h, chk_IAPWS95_Table8

Print #h, chk_IAPWS06_Table6

Print #h, chk_IAPWS08_Table8a
Print #h, chk_IAPWS08_Table8b
Print #h, chk_IAPWS08_Table8c

Print #h, chk_IAPWS09_Table6

Print #h, chk_IAPWS10_Table13
Print #h, chk_IAPWS10_Table14
Print #h, chk_IAPWS10_Table15

Print #h, chk_OS2008_Table2
Print #h, chk_OS2008_Table3
Print #h, chk_OS2008_TableA2
Print #h, chk_OS2008_TableA3
Print #h, chk_OS2008_TableA4
Print #h, chk_OS2008_TableA5
Print #h, chk_OS2008_TableA6
Print #h, chk_OS2008_TableA7
Print #h, chk_OS2008_TableA8

limits = check_limits
check_limits = 0      'disable range checking
Print #h, chk_lemmon_etal_2000(0)
Print #h, chk_lemmon_etal_2000(1)
check_limits = limits 'restore range checking

Print #h, chk_IAPWS97_Table5
Print #h, chk_IAPWS97_Table15

Me.MousePointer = vbNormal

Close h

End Sub

Private Sub File_SaveCheckValues_Click()
Dim path$, h%

path = App.path
If Right(path, 1) <> "\" Then path = path + "\"
h% = FreeFile
Open path + "SIA_CheckValues.txt" For Output As #h

Me.MousePointer = vbHourglass

Print #h, flu_check_values
Print #h, ice_check_values
Print #h, sal_check_values
Print #h, sea_check_values
Print #h, air_check_values
Print #h, mix_check_values
Print #h, gsw_check_values
Print #h, cnv_check_values

Me.MousePointer = vbNormal

Close h

End Sub


Private Sub File_SaveExamples_Click()
Dim path$, h%

path = App.path
If Right(path, 1) <> "\" Then path = path + "\"
h% = FreeFile
Open path + "SIA_Examples.txt" For Output As #h

Me.MousePointer = vbHourglass

Print #h, Flu_2_example_call(273.16, 999.792520031621)
Print #h, Ice_2_example_call(273.15, 101325)
Print #h, Sea_3a_example_call(0.03516504, 273.15, 101325)
Print #h, air_2_example_call(0.99, 273.15, 1.2853)

Me.MousePointer = vbNormal

Close h

End Sub

Private Sub IAPWS09_Check_Click(Index As Integer)

TextWindow

Me.Print chk_IAPWS09_Table6

End Sub

Private Sub IAPWS97_Check_Click(Index As Integer)
Dim txt$

TextWindow

Select Case Index
  Case 0: txt$ = chk_IAPWS97_Table5
  Case 1: txt$ = chk_IAPWS97_Table15
End Select

Me.Print txt
Debug.Print txt

End Sub

Private Sub Check_Lemmon_Click(Index As Integer)

Dim txt$, limits%

TextWindow

limits = check_limits
check_limits = 0      'disable range checking

txt = chk_lemmon_etal_2000(Index)

Me.Print txt
Debug.Print txt

check_limits = limits 'restore range checking

End Sub

Private Sub Examples_AirProperties_Click()

Dim a As Double, t As Double, d As Double

TextWindow

'computation example: set any values of A, T and P you like
a = 0.99
t = 273.15
d = 1.2853

Me.Print air_2_example_call(a, t, d)

End Sub


Private Sub Examples_FluidWaterProperties_Click()

Dim t As Double, d As Double

TextWindow

'computation example: set any values of T and D you like

'P = 611.655           'experimental triple point pressure
t = 273.16             'triple point temperature, exact by ITS-90
d = 999.792520031621   'triple point density. Table value is 999.793

Me.Print Flu_2_example_call(t, d)

End Sub

Private Sub Examples_IceIhProperties_Click()

Dim t As Double, p As Double

TextWindow

'computation example: set any values of T and P you like
t = 273.15
p = 101325

Me.Print Ice_2_example_call(t, p)

End Sub

Private Sub File_Exit_Click()
Unload Me
End Sub

Private Sub Form_Load()

Me.Caption = "TEOS-10: SIA Library Functions Version 3.0   (" + Version + ")"

Form_Resize

End Sub


Private Sub Form_Resize()

If Iceberg_Img.Visible = False Then Exit Sub

If Iceberg_Img.Height < 2 * Title_lbl(0).Height Then
  Iceberg_Img.Height = 2 * Title_lbl(0).Height
End If

Iceberg_Img.Left = 0
Iceberg_Img.Top = 0
Iceberg_Img.Width = Me.ScaleWidth
Iceberg_Img.Height = Me.ScaleHeight

Title_lbl(0).Left = 0
Title_lbl(0).Top = Iceberg_Img.Height - Title_lbl(0).Height
Title_lbl(0).Width = Iceberg_Img.Width

Title_lbl(1).Left = 0
Title_lbl(1).Top = Title_lbl(1).Height
Title_lbl(1).Width = Iceberg_Img.Width

End Sub




Private Sub IAPWS06_Check_Click(Index As Integer)

TextWindow

Me.Print chk_IAPWS06_Table6

End Sub

Private Sub IAPWS08_Check_Click(Index As Integer)

Dim txt$

TextWindow

Select Case Index
  Case 0: txt$ = chk_IAPWS08_Table8a
  Case 1: txt$ = chk_IAPWS08_Table8b
  Case 2: txt$ = chk_IAPWS08_Table8c
End Select

Me.Print txt
Debug.Print txt

End Sub

Private Sub IAPWS10_Check_Click(Index As Integer)

Dim txt$

TextWindow

Select Case Index
  Case 0: txt$ = chk_IAPWS10_Table13
  Case 1: txt$ = chk_IAPWS10_Table14
  Case 2: txt$ = chk_IAPWS10_Table15
End Select

Me.Print txt
Debug.Print txt

End Sub

Private Sub IAPWS95_Check_Click(Index As Integer)

Dim txt$

TextWindow

Select Case Index
  Case 0: txt$ = chk_IAPWS95_Table6
  Case 1: txt$ = chk_IAPWS95_Table7
  Case 2: txt$ = chk_IAPWS95_Table8
End Select

Me.Print txt
Debug.Print txt

End Sub


Private Sub Menu_Info_Click()

TextWindow

Me.Print InfoText

End Sub


Private Sub Quad_Table2_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_Table2

Me.Print txt
Debug.Print txt

End Sub

Private Sub Quad_Table3_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_Table3

Me.Print txt
Debug.Print txt

End Sub


Private Sub Quad_TableA1_Click()
Dim txt$

TextWindow

txt$ = chk_OS2008_TableA1

Me.Print txt
Debug.Print txt

End Sub

Private Sub Quad_TableA2_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA2

Me.Print txt
Debug.Print txt

End Sub

Private Sub Quad_TableA3_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA3

Me.Print txt
Debug.Print txt

End Sub


Private Sub Quad_TableA4_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA4

Me.Print txt
Debug.Print txt

End Sub

Private Sub Quad_TableA5_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA5

Me.Print txt
Debug.Print txt

End Sub


Private Sub Quad_TableA6_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA6

Me.Print txt
Debug.Print txt

End Sub


Private Sub Quad_TableA7_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA7

Me.Print txt
Debug.Print txt

End Sub


Private Sub Quad_TableA8_Click()

Dim txt$

TextWindow

txt$ = chk_OS2008_TableA8

Me.Print txt
Debug.Print txt

End Sub


