Attribute VB_Name = "air_5_Mdl"
Option Explicit

'#########################################################################

'This module requires the library modules:
'     Constants_0_Mdl, file Constants_0.bas
'     Air_3b_Mdl,      file Air_3b.bas
'     Liq_Air_3a_Mdl,  file Liq_Air_3a.bas

'#########################################################################

'=========================================================================
'This module implements properties of humid air that are expressed in
'non-basic SI units or require additional empirical constants.

'Implementation in VB6 by Rainer Feistel
'for publication in Ocean Science, as described in the papers

'Feistel, R., Wright, D.G., Jackett, D.R., Miyagawa, K., Reissmann, J.H.,
'Wagner, W., Overhoff, U., Guder, C., Feistel, A., Marion, G.M.:
'Numerical implementation and oceanographic application of the thermodynamic
'potentials of water, vapour, ice, seawater and air. Part I: Background and Equations.
'Ocean Science, 2009

'Wright, D.G., Feistel, R., Jackett, D.R., Miyagawa, K., Reissmann, J.H.,
'Wagner, W., Overhoff, U., Guder, C., Feistel, A., Marion, G.M.:
'Numerical implementation and oceanographic application of the thermodynamic
'potentials of water, vapour, ice, seawater and air. Part II: The Library Routines,
'Ocean Science, 2009

'Feistel, R., Kretzschmar, H.-J., Span, R., Hagen, E., Wright, D.G., Herrmann, S.:
'Thermodynamic Properties of Sea Air.
'Ocean Science Discussion 6(2009)21932325.
'==========================================================================
'Private Const ErrorReturn = 9.99999999E+98

Private Const Version = "28 May 2010"
Public Function air_lapserate_moist_c100m(ByVal rh_percent As Double, _
                                          ByVal t_c As Double, _
                                          ByVal p_hPa As Double) As Double

'This function returns the adiabatic lapse rate of humid air in C per 100 m altitude
'Input parameters
'rh_percent:  relative humidity WMO definition in % between 0 and 100
't_c:         temperature in C
'p_hPa:       absolute pressure in hPa

'CHECK VALUE:
'air_lapserate_moist_c100m(50, 20, 1000) = 0.971359680720479  v. 1.0
'air_lapserate_moist_c100m(50, 20, 1000) = 0.971588085046374  v. 1.1

Const g = 9.81  'm/s2   gravity
Const h = 100   'm      altitude difference

Dim lr As Double, d As Double
Dim a_si As Double, t_si As Double, p_si As Double

air_lapserate_moist_c100m = ErrorReturn

'convert to basic SI units:
t_si = 273.15 + t_c
p_si = p_hPa * 100

'compute dry-air fraction from RH
a_si = liq_air_a_from_rh_wmo_si(rh_percent * 0.01, t_si, p_si)
If a_si = ErrorReturn Then Exit Function

'compute lapse rate wrt. pressure
lr = air_g_lapserate_si(a_si, t_si, p_si)
If lr = ErrorReturn Then Exit Function

'compute humid air density
d = air_g_density_si(a_si, t_si, p_si)
If d = ErrorReturn Then Exit Function

'get the lapse rate wrt 100 m sinking
air_lapserate_moist_c100m = lr * d * g * h

End Function



