program chk_tables_all

!THIS PROGRAM REQUIRES
!     CONSTANTS_0, FILE CONSTANTS_0.F90
!     CONVERT_0,   FILE CONVERT_0.F90
!     MATHS_0,     FILE MATHS.F90
!     AIR_1,       FILE AIR_1.F90
!     FLU_1,       FILE FLU_1.F90
!     ICE_1,       FILE ICE_1.F90
!     SAL_1,       FILE SAL_1.F90
!     AIR_2,       FILE AIR_2.F90
!     FLU_2,       FILE FLU_2.F90
!     SAL_2,       FILE SAL_2.F90
!     AIR_3b,      FILE AIR_3b.F90
!     FLU_3A,      FILE FLU_3A.F90
!     LIQ_VAP_4,   FILE LIQ_VAP_4.F90
!     FLU_IF97_5,  FILE FLU_IF97_5.F90
!     LIQ_F03_5,   FILE LIQ_F03_5.F90
!     OS2008_5,    FILE OS2008_5.F90


use constants_0
use convert_0
use maths_0
use air_1
use flu_1
use ice_1
use sal_1
use air_2
use flu_2
use sal_2
use air_3b
use flu_3a
use liq_vap_4
use flu_if97_5
use liq_f03_5
use os2008_5

implicit none 
!character*11, private :: version = '31 Jan 2012'

check_limits = 0

!=========================================================================

!THIS PROGRAM PRODUCES COMPARISON TABLES WITH THE CHECK VALUES PUBLISHED IN
!R. FEISTEL, D.G. WRIGHT, K. MIYAGAWA, A.H. HARVEY, J. HRUBY, D.R. JACKETT, T.J. MCDOUGALL, W.WAGNER
!MUTUALLY CONSISTENT THERMODYNAMIC POTENTIALS FOR FLUID WATER, ICE AND SEAWATER:
!A NEW STANDARD FOR OCEANOGRAPHY.
!OCEAN SCI., 4, 275-291, 2008
!WWW.OCEAN-SCI.NET/4/275/2008/
!WITH THE IMPLEMENTATION IN THIS LIBRARY.

!==========================================================================
!IMPLEMENTATION IN FORTRAN BY D.G. WRIGHT
!FOR PUBLICATION IN OCEAN SCIENCE, AS DESCRIBED IN THE PAPERS

!FEISTEL, R., WRIGHT, D.G., JACKETT, D.R., MIYAGAWA, K., REISSMANN, J.H.,
!WAGNER, W., OVERHOFF, U., GUDER, C., FEISTEL, A., MARION, G.M.:
!NUMERICAL IMPLEMENTATION AND OCEANOGRAPHIC APPLICATION OF THE THERMODYNAMIC
!POTENTIALS OF WATER, VAPOUR, ICE, SEAWATER AND AIR. PART I: BACKGROUND AND EQUATIONS. 
!OCEAN SCIENCES, 2009, IN PREPARATION.

!WRIGHT, D.G., FEISTEL, R., JACKETT, D.R., MIYAGAWA, K., REISSMANN, J.H., 
!WAGNER, W., OVERHOFF, U., GUDER, C., FEISTEL, A., MARION, G.M.:
!NUMERICAL IMPLEMENTATION AND OCEANOGRAPHIC APPLICATION OF THE THERMODYNAMIC
!POTENTIALS OF WATER, VAPOUR, ICE, SEAWATER AND AIR. PART II: THE LIBRARY ROUTINES, 
!OCEAN SCIENCES., 2009, IN PREPARATION.

!FEISTEL, R., KRETZSCHMAR, H.-J., SPAN, R., HAGEN, E., !WRIGHT, D.G., JACKETT, D.R.:
!THERMODYNAMIC PROPERTIES OF SEA AIR.
!OCEAN SCIENCES, 2009, IN PREPARATION.
!==========================================================================

call chk_os2008_table("2")
call chk_os2008_table("3") 
call chk_os2008_table("A1") 
call chk_os2008_table("A2")
call chk_os2008_table("A3")
call chk_os2008_table("A4")  
call chk_os2008_table("A5") 
call chk_os2008_table("A6")
call chk_os2008_table("A7")
call chk_os2008_table("A8")  


!THIS PROGRAM PROVIDES EASY COMPARISON OF SELECTED RESULTS WITH THOSE APPEARING IN:

!LEMMON, E.W., JACOBSEN, R.T., PENONCELLO, S.G., FRIEND, D.G.
!THERMODYNAMIC PROPERTIES OF AIR AND MIXTURES OF NITROGEN, ARGON AND OXYGEN
!FROM 60 TO 2000 K AT PRESSURES TO 2000 MPA.
!J. PHYS. CHEM. REF. DATA 29(2000)331-362.

!AND 

!GUIDELINE ON AN EQUATION OF STATE FOR HUMID AIR IN CONTACT WITH SEAWATER AND ICE,
!CONSISTENT WITH THE IAPWS FORMULATION 2008 FOR THE THERMODYNAMIC PROPERTIES OF SEAWATER
!THE INTERNATIONAL ASSOCIATION FOR THE PROPERTIES OF WATER AND STEAM
!NIAGARA FALLS, CANADA, SEPTEMBER 2010 IN PREPARATION

call chk_iapws10_table(13)
call chk_iapws10_table(14)
call chk_iapws10_table(15)
call chk_lemmon_etal_2000(1)
call chk_lemmon_etal_2000(2)


!FUNCTION VALUES AS GIVEN IN TABLE 6 OF IAPWS-09:
!NUMERICAL CHECK VALUES FOR THE GIBBS FUNCTION G AND ITS DERIVATIVES, TABLE 4
!THE NUMERICAL FUNCTIONS EVALUATED HERE AT GIVEN POINTS (T, P) ARE DEFINED IN TABLES 3 AND 4

call chk_iapws09_table6


!FUNCTION VALUES AS GIVEN IN TABLE 5 OF IF-97:
!TABLE 5. THERMODYNAMIC PROPERTY VALUES CALCULATED FROM EQ. (7) 
!FOR SELECTED VALUES OF T AND P

call chk_iapws97_table(5)


!FUNCTION VALUES AS GIVEN IN TABLE 15 OF IF-97:
!TABLE 15. THERMODYNAMIC PROPERTY VALUES CALCULATED FROM EQ. (15) 
!FOR SELECTED VALUES OF T AND P

call chk_iapws97_table(15)

end program
