Attribute VB_Name = "Constants_0_Mdl"
Option Explicit

'#########################################################################

'This module is self-contained and does not require other library modules

'#########################################################################

'=========================================================================
'This modules contains the definitions of basic constants of the library

'The values of these constants are consistent with the functions and
'constants used in this source code library, rather than being independent entities.
'Future updates are only possible if this consistency is carefully maintained


'Impose necessary parameter limits
'For the check, initialize initial_check_limits_value to 1. It is used internally
'to turn all limit checking off within the iterative solution routines:
Public Const initial_check_limits_value = 1
'To suppress all restrictive checks, initialize initial_check_limits_value to zero:
'Public Const initial_check_limits_value = 0

Private check_limits_value As Integer 'this is initialized in Property Get check_limits()

'parameter ranges used for check_limits:
Public Const dry_air_tmin = 60#
Public Const dry_air_tmax = 873#
Public Const dry_air_dmin = 0#
Public Const dry_air_dmax = 1035#

Public Const mix_air_tmin = 193#
Public Const mix_air_tmax = 473#
Public Const mix_air_dmin = 0#
Public Const mix_air_dmax = 100#

Public Const flu_tmin = 50#
Public Const flu_tmax = 1273#
Public Const flu_dmin = 0#
Public Const flu_dmax = 1240#

Public Const ice_tmin = 0#
Public Const ice_tmax = 273.16
Public Const ice_pmin = 0#
Public Const ice_pmax = 200000000#

Public Const sal_tmin = 262#
Public Const sal_tmax = 353#
Public Const sal_pmin = 100#
Public Const sal_pmax = 100000000#
Public Const sal_smin = 0#
Public Const sal_smax = 0.12

'To extend the Gibbs function as described in these two papers:

  'R. Feistel
  'Extended Equation of State for Seawater at Elevated Temperature and Salinity
  'Desalination, 250, 14-18, 2010
  '
  'to cover the measurements of
  'F. Millero and F. Huang
  'Ocean Sci. Discuss. 6 (2009) 153-169.
  'http://www.ocean-sci-discuss.net/6/153/2009/
  
'set this constant to True:
'Public Const IsExtension2010 = True
'Note that this optional Gibbs function is not endorsed by IAPWS
Public Const IsExtension2010 = False

'procedure return codes
Public Const ErrorReturn = 9.99999999E+98
Public Const IsOK = -1

'Mathematical constants
Public Const PI = 3.14159265358979

'Fundamental physical constants
Public Const Gas_constant_molar_si = 8.314472                  'molar gas constant J mol-1 K-1, IAPWS 2005
Public Const Gas_constant_molar_L2000 = 8.31451                'molar gas constant J mol-1 K-1, Lemmon et al. 2000

Public Const Molar_mass_H2O_si = 0.018015268                   'molar mass of H2O in kg mol-1,      IAPWS 2009
Public Const Molar_mass_seasalt_si = 0.0314038218              'molar mass of sea salt in kg mol-1, Millero et al. 2008
Public Const Molar_mass_air_si = 0.02896546                    'molar mass of dry air in kg mol-1,  Picard et al. 2008

'Version 1.0:
'Public Const Molar_mass_air_L2000 = 0.0289586                  'molar mass of dry air in kg mol-1,  Lemmon et al. 2000

'Version 1.1:
'Lemmon et al. (2000) decided to use the latest molar mass with their molar formulation.
'For consistency with IAPWS-10, the SIA libary version 1.1 is also changed to this value
'27 May 2010
Public Const Molar_mass_air_L2000 = Molar_mass_air_si

Public Const Gas_constant_H2O_si = Gas_constant_molar_si / Molar_mass_H2O_si            'specific gas constant of H2O in J kg-1 K-1, IAPWS 2005
Public Const Gas_constant_H2O_IAPWS95 = 461.51805                                       'specific gas constant of H2O in J kg-1 K-1, IAPWS-95
Public Const Gas_constant_air_si = Gas_constant_molar_si / Molar_mass_air_si            'specific gas constant of air in J kg-1 K-1, Picard et al. 2008
Public Const Gas_constant_air_L2000 = Gas_constant_molar_L2000 / Molar_mass_air_L2000   'specific gas constant of air in J kg-1 K-1, Lemmon et al. 2000

Public Const Sealevel_pressure_si = 101325                     'Pa
Public Const Celsius_temperature_si = 273.15                   'K,          ITS-90 definition

'Standard ocean properties, Millero et al. 2008
Public Const SO_salinity_si = 0.03516504                       'kg kg-1,    of KCl-normalised seawater, Millero et al. 2008
Public Const SO_temperature_si = Celsius_temperature_si        'K
Public Const SO_pressure_si = Sealevel_pressure_si             'Pa

'Critical point of pure water, IAPWS-95
Public Const CP_density_si = 322#                              'kg m-3
Public Const CP_temperature_si = 647.096                       'K
Public Const CP_pressure_si = 22064000#                        'Pa
Public Const CP_chempot_si = -767471.156792841                 'in J kg-1

'Triple Point of pure water
Public Const TP_temperature_si = 273.16                                   'K,      ITS-90 definition
Public Const TP_pressure_exp_si = 611.657                                 'Pa,     experimental triple point pressure, IAPWS-95
'Public Const TP_pressure_IAPWS95_si =611.6547710078944264442598E-6        Pa,     from quadruple-precision computation, Feistel et al. 2008
Public Const TP_pressure_IAPWS95_si = 611.654771007894                    'Pa
'Public Const TP_density_vap_IAPWS95_si =4.854575724778588417176210E-3     kg m-3, from quadruple-precision computation, Feistel et al. 2008
Public Const TP_density_vap_IAPWS95_si = 4.85457572477859E-03             'kg m-3
'Public Const TP_density_liq_IAPWS95_si =999.792520031620646603898354735   kg m-3, from quadruple-precision computation, Feistel et al. 2008
Public Const TP_density_liq_IAPWS95_si = 999.792520031621                 'kg m-3
Public Const TP_density_ice_IAPWS95_si = 916.709492199488                 'kg m-3
Public Const TP_enthalpy_vap_si = 2500915.1914657                         'J kg-1
Public Const TP_enthalpy_ice_si = -333444.253967839                       'J kg-1

'References:

'Feistel et al. 2008:
'Feistel, R., Wright, D.G., Miyagawa, K., Harvey, A.H., Hruby, J., Jackett, D.R., McDougall, T.J. and Wagner, W.:
'Mutually Consistent Thermodynamic Potentials for Fluid Water, Ice, and Seawater: A New Standard for Oceanography,
'Ocean Sci., 4, 275-291, 2008, available at: www.ocean-sci.net/4/275/2008/

'IAPWS-95:
'Release on the IAPWS Formulation 1995 for the Thermodynamic Properties of Ordinary Water Substance for General and Scientific Use
'The International Association for the Properties of Water and Steam
'Doorwerth, The Netherlands, September 2009
'(original Release: Fredericia, Denmark, September 1996)
'available at:  http://www.iapws.org

'IAPWS 2005:
'IAPWS: Guideline on the Use of Fundamental Physical Constants and Basic Constants of Water.
'The International Association for the Properties of Water and Steam. Gaithersburg, Mayland, USA, September 2001.
'Revision July 2005, available at: http://www.iapws.org

'Lemmon et al. 2000:
'Lemmon, E.W., Jacobsen, R.T., Penoncello, S.G. and Friend, D.G.:
'Thermodynamic Properties of Air and Mixtures of Nitrogen, Argon and Oxygen From 60 to 2000 K at Pressures to 2000 MPa,
'J. Phys. Chem. Ref. Data, 29, 331-362, 2000

'Millero et al. 2008:
'Millero, F.J., Feistel, R., Wright, D.G. and McDougall, T.J.:
'The composition of Standard Seawater and the definition of the Reference-Composition Salinity Scale,
'Deep-Sea Res. I, 55, 50-72, 2008

'Picard et al. 2008:
'Picard, A., Davis, R.S., Glser, M. and Fujii, K.:
'Revised formula for the density of moist air (CIPM-2007),
'Metrologia, 45, 149-155, 2008

'IAPWS: Guideline on an Equation of State for Humid Air in Contact with Seawater and Ice,
'Consistent with the IAPWS Formulation 2008 for the Thermodynamic Properties of Seawater.
'The International Association for the Properties of Water and Steam,
'Niagara Falls, Canada, September 2010, to be adopted

Private initialized As Integer

Private Const Version = "27 May 2010"

'======================================================================
Public Property Get check_limits() As Integer

If initialized <> 1 Then 'initialize only once
  initialized = 1

 'this initializes a more restrictive checking of validity ranges
 'during the iteration loops of several modules
 check_limits_value = initial_check_limits_value

End If

check_limits = check_limits_value

End Property

'======================================================================
Public Property Let check_limits(the_value As Integer)

check_limits_value = the_value
initialized = 1        'do not overwrite later this setting by initializing

End Property

